/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class FileOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(FileOutputSynapse.class);
    private String FileName = "";
    private boolean append = false;
    protected transient PrintWriter printer = null;
    private static final long serialVersionUID = 3194671306693862830L;

    @Override
    public synchronized void write(Pattern pattern) {
        if (this.printer == null || pattern.getCount() == 1) {
            this.setFileName(this.FileName);
        }
        if (pattern.getCount() == -1) {
            this.flush();
        } else {
            double[] array = pattern.getArray();
            for (int i = 0; i < array.length; ++i) {
                this.printer.print(array[i]);
                if (i >= array.length - 1) continue;
                this.printer.print(this.getSeparator());
            }
            this.printer.println();
        }
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String fn) {
        block3: {
            this.FileName = fn;
            try {
                if (this.printer != null) {
                    this.printer.close();
                }
                this.printer = new PrintWriter(new FileOutputStream(fn, this.isAppend()), true);
            }
            catch (IOException ioe) {
                String error = "IOException in " + this.getName() + ". Message is : ";
                log.error(error + ioe.getMessage());
                if (this.getMonitor() == null) break block3;
                new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
            }
        }
    }

    public void flush() {
        this.printer.flush();
        this.printer.close();
        this.printer = null;
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.FileName == null || this.FileName.trim().equals("")) {
            checks.add(new NetCheck(0, "File Name not set.", this));
        }
        return checks;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}

