/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import org.joone.engine.learning.TeacherSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class FahlmanTeacherSynapse
extends TeacherSynapse {
    public static final String CRITERION = "FAHLMAN_CRITERION";
    protected static final ILogger log = LoggerFactory.getLogger(FahlmanTeacherSynapse.class);
    private double upperBit = 1.0;
    private double lowerBit = 0.0;
    private double lowerBitPercentage = 0.4;
    private double upperBitPercentage = 0.4;

    public void setUpperBit(double aValue) {
        this.upperBit = aValue;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double aValue) {
        this.lowerBit = aValue;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }

    public void setUpperBitPercentage(double aValue) {
        this.upperBitPercentage = aValue;
    }

    public double getUpperBitPercentage() {
        return this.upperBitPercentage;
    }

    public void setLowerBitPercentage(double aValue) {
        this.lowerBitPercentage = aValue;
    }

    public double getLowerBitPercentage() {
        return this.lowerBitPercentage;
    }

    @Override
    protected double calculateError(double aDesired, double anOutput, int anIndex) {
        if (this.getMonitor().isValidation()) {
            double myRange = this.upperBit - this.lowerBit;
            if (aDesired == this.lowerBit) {
                if (!(anOutput >= this.lowerBit) || !(anOutput <= this.lowerBit + (myRange *= this.lowerBitPercentage))) {
                    this.getMonitor().setParam(CRITERION, Boolean.FALSE);
                }
            } else if (aDesired == this.upperBit) {
                if (!(anOutput >= this.upperBit - (myRange *= this.upperBitPercentage)) || !(anOutput <= this.upperBit)) {
                    this.getMonitor().setParam(CRITERION, Boolean.FALSE);
                }
            } else {
                log.warn("The values for upper and/or lower bit are not correctly set. No match for desired output " + aDesired + ".");
                this.getMonitor().setParam(CRITERION, Boolean.FALSE);
            }
        }
        return super.calculateError(aDesired, anOutput, anIndex);
    }
}

