/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class WTALayer
extends SimpleLayer {
    private static final ILogger log = LoggerFactory.getLogger(WTALayer.class);
    private static final long serialVersionUID = -941653911909171430L;
    private int LayerWidth = 1;
    private int LayerHeight = 1;
    private int LayerDepth = 1;

    public WTALayer() {
    }

    public WTALayer(String ElemName) {
        super(ElemName);
    }

    @Override
    public void backward(double[] pattern) throws JooneRuntimeException {
    }

    @Override
    public void forward(double[] pattern) throws JooneRuntimeException {
        int x = 0;
        double in = 0.0;
        int winner = 0;
        double min_dist = 1.0E13f;
        int n = this.getRows();
        try {
            for (x = 0; x < n; ++x) {
                in = pattern[x];
                if (!(in < min_dist)) continue;
                min_dist = in;
                winner = x;
            }
            for (x = 0; x < n; ++x) {
                this.outs[x] = x == winner ? 1.0 : 0.0;
            }
        }
        catch (Exception aioobe) {
            String msg = "Exception thrown while processing the element " + x + " of the array. Value is : " + pattern[x] + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    public int getLayerDepth() {
        return this.LayerDepth;
    }

    public void setLayerDepth(int LayerDepth) {
        if (LayerDepth != this.getLayerDepth()) {
            this.LayerDepth = LayerDepth;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    public int getLayerHeight() {
        return this.LayerHeight;
    }

    public void setLayerHeight(int LayerHeight) {
        if (LayerHeight != this.getLayerHeight()) {
            this.LayerHeight = LayerHeight;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    public int getLayerWidth() {
        return this.LayerWidth;
    }

    public void setLayerWidth(int LayerWidth) {
        if (LayerWidth != this.getLayerWidth()) {
            this.LayerWidth = LayerWidth;
            this.setRows(this.getLayerWidth() * this.getLayerHeight() * this.getLayerDepth());
            this.setDimensions();
            this.setConnDimensions();
        }
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getLayerWidth() < 1) {
            checks.add(new NetCheck(0, "Layer width should be greater than or equal to 1.", this));
        }
        if (this.getLayerHeight() < 1) {
            checks.add(new NetCheck(0, "Layer height should be greater than or equal to 1.", this));
        }
        if (this.getLayerDepth() < 1) {
            checks.add(new NetCheck(0, "Layer depth should be greater than or equal to 1.", this));
        }
        return checks;
    }

    @Override
    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }
}

