/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.joone.edit.PropertyPanel;
import org.joone.edit.Wrapper;
import org.joone.net.NeuralNet;

public class PropertySheet
extends JFrame {
    private PropertyPanel panel;
    protected Wrapper target;
    protected NeuralNet nNet;
    private static final long serialVersionUID = -3520314914318159702L;
    private boolean enabled;

    PropertySheet(int x, int y) {
        this(null, x, y, null);
    }

    PropertySheet(Wrapper wr, int x, int y) {
        this(wr, x, y, null);
    }

    PropertySheet(Wrapper wr, int x, int y, NeuralNet nn) {
        super("Properties - <initializing...>");
        this.target = wr;
        this.nNet = nn;
        if (this.target != null) {
            this.setTarget(wr);
        }
        this.initialize(x, y);
    }

    protected void initialize(int x, int y) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.gray);
        this.setLocation(x, y);
        this.getContentPane().add((Component)this.getContents(), "Center");
        this.setTitle("Properties window");
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image img = kit.loadImageResource("/org/joone/images/JooneIcon.gif");
        this.setIconImage(img);
        this.pack();
    }

    protected JComponent getContents() {
        return this.getPanel();
    }

    public void setTarget(Wrapper targ) {
        this.target = targ;
        String displayName = this.target.getBeanName();
        this.getPanel().setTarget(this.target);
        this.setTitle("Properties - " + displayName);
    }

    protected PropertyPanel getPanel() {
        if (this.panel == null) {
            this.panel = new PropertyPanel();
        }
        return this.panel;
    }

    public boolean isControlsEnabled() {
        return this.enabled;
    }

    public void setControlsEnabled(boolean enabled) {
        this.enabled = enabled;
        this.getPanel().setEnabled(enabled);
    }

    public void update() {
        this.getPanel().update();
    }
}

