/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.SerializationStorageFormat;
import CH.ifa.draw.util.StorageFormat;
import CH.ifa.draw.util.StorageFormatManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Calendar;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.joone.edit.AboutFrame;
import org.joone.edit.DelegationSelectionTool;
import org.joone.edit.EditorParameters;
import org.joone.edit.IniFile;
import org.joone.edit.JMacroEditor;
import org.joone.edit.JooneCommandMenu;
import org.joone.edit.JooneCopyCommand;
import org.joone.edit.JooneCutCommand;
import org.joone.edit.JooneDuplicateCommand;
import org.joone.edit.JooneFileChooser;
import org.joone.edit.JooneStandardDrawingView;
import org.joone.edit.LayerFigure;
import org.joone.edit.LayerFigureCreationTool;
import org.joone.edit.MonitorPropertySheet;
import org.joone.edit.NetStorageFormat;
import org.joone.edit.NetStorageFormatManager;
import org.joone.edit.NeuralNetDrawing;
import org.joone.edit.PropertySheet;
import org.joone.edit.StandardNetStorageFormat;
import org.joone.edit.SynapseCreationTool;
import org.joone.edit.TodoFrame;
import org.joone.edit.ToolElement;
import org.joone.edit.ToolsSAXParser;
import org.joone.edit.Wrapper;
import org.joone.edit.XMLNetStorageFormat;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.samples.editor.som.SOMImageTester;
import org.joone.util.MacroPlugin;

public class JoonEdit
extends DrawApplication {
    private static final ILogger log = LoggerFactory.getLogger(JoonEdit.class);
    private static final int MAJOR_RELEASE = 2;
    private static final int MINOR_RELEASE = 0;
    private static final int BUILD = 0;
    private static final String SUFFIX = "RC1";
    public static final String INI_FILE_NAME = "joonedit.config";
    private static final int RECO_ENG_MAJOR_RELEASE = 1;
    private static final int RECO_ENG_MINOR_RELEASE = 2;
    private static final int RECO_ENG_BUILD = 5;
    public static final String DIAGRAM_IMAGES = "/org/joone/images/";
    public static final String MENU_IMAGES = "/org/joone/images/menu/";
    private PropertySheet psp;
    private InputStream XMLParamsFile;
    private JooneFileChooser m_openDialog = null;
    private NetStorageFormatManager fNetStorageFormatManager;
    private NetStorageFormatManager xNetStorageFormatManager;
    private ToolsSAXParser tParser;
    private EditorParameters parameters;
    private MonitorPropertySheet ps;
    private static final long serialVersionUID = -4579162097589626753L;
    private AboutFrame af = null;
    private TodoFrame tf = null;
    private StorageFormat latestStorageFormat;
    private JMacroEditor macroEditor;
    private IniFile iniFile = null;
    private int width = 800;
    private int height = 600;

    public JoonEdit(String params) {
        super("JoonEdit - Joone Neural Net Editor");
        try {
            this.initJoonEdit(new FileInputStream(params));
        }
        catch (FileNotFoundException fnfe) {
            log.fatal("FileNotFoundException thrown with params " + params + ". Message is " + fnfe.getMessage(), fnfe);
            System.exit(0);
        }
    }

    public JoonEdit() {
        super("JoonEdit - Joone Neural Net Editor");
        InputStream is = this.getClass().getResourceAsStream("/org/joone/data/layers.xml");
        this.initJoonEdit(is);
    }

    private void initJoonEdit(InputStream isParams) {
        this.XMLParamsFile = isParams;
        this.fNetStorageFormatManager = this.createNetStorageFormatManager();
        this.xNetStorageFormatManager = this.createXMLStorageFormatManager();
        this.setDefaultCloseOperation(0);
        this.readIniFile();
    }

    public static void center(Window frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
    }

    @Override
    protected JComponent createContents(StandardDrawingView view) {
        JPanel jpan = new JPanel();
        jpan.setLayout(new BorderLayout());
        JScrollPane rsp = (JScrollPane)super.createContents(view);
        JPanel ptools = new JPanel(new BorderLayout());
        JToolBar[] tools = new JToolBar[2];
        for (int i = 0; i < tools.length; ++i) {
            tools[i] = this.createToolPalette();
        }
        this.createMyTools(tools);
        ptools.add((Component)tools[0], "North");
        ptools.add((Component)tools[1], "South");
        jpan.add((Component)ptools, "North");
        jpan.add((Component)rsp, "Center");
        return jpan;
    }

    @Override
    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        palette.addSeparator();
        AbstractTool tool = new TextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Label", tool));
        tool = new ConnectedTextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool));
        palette.addSeparator();
        tool = new CreationTool(this.view(), new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new RoundRectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new EllipseFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new CreationTool(this.view(), new TriangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new CreationTool(this.view(), new DiamondFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool));
        tool = new PolygonTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new CreationTool(this.view(), new LineFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new BorderTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", tool));
        tool = new ScribbleTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
    }

    protected void createMyTools(JToolBar[] palettes) {
        this.tParser = new ToolsSAXParser(this.XMLParamsFile);
        Vector elements = this.tParser.getElements();
        JToolBar palette = palettes[0];
        for (int i = 0; i < elements.size(); ++i) {
            LayerFigureCreationTool LFCtool;
            ToolElement te = (ToolElement)elements.elementAt(i);
            if (te.getType().compareToIgnoreCase("break") == 0) {
                palette = palettes[1];
            }
            if (te.getType().compareToIgnoreCase("separator") == 0) {
                palette.addSeparator();
            }
            if (te.getType().compareToIgnoreCase("layer") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.LayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type") + " layer", LFCtool));
            }
            if (te.getType().compareToIgnoreCase("input_layer") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type") + " layer", LFCtool));
            }
            if (te.getType().compareToIgnoreCase("output_layer") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type") + " layer", LFCtool));
            }
            if (te.getType().compareToIgnoreCase("teacher_layer") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.TeacherLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type") + " layer", LFCtool));
            }
            if (te.getType().compareToIgnoreCase("input_plugin") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputPluginLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("monitor_plugin") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.MonitorPluginFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("input_switch") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputSwitchLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("input_connector") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.InputConnectorLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("output_switch") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputSwitchLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("script_plugin") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.ScriptPluginFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("learning_switch") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.LearningSwitchLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("synapse") == 0) {
                SynapseCreationTool SCtool = new SynapseCreationTool(this.view(), "org.joone.edit.LayerConnection");
                SCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)SCtool.getParam("image"), "New " + (String)SCtool.getParam("type"), SCtool));
            }
            if (te.getType().compareToIgnoreCase("output_plugin") == 0) {
                LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.OutputPluginLayerFigure");
                LFCtool.setParams(te.getParams());
                palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
            }
            if (te.getType().compareToIgnoreCase("chart_handle") != 0) continue;
            LFCtool = new LayerFigureCreationTool(this.view(), "org.joone.edit.ChartHandleLayerFigure");
            LFCtool.setParams(te.getParams());
            palette.add(this.createToolButton(DIAGRAM_IMAGES + (String)LFCtool.getParam("image"), "New " + (String)LFCtool.getParam("type"), LFCtool));
        }
    }

    @Override
    protected Tool createSelectionTool() {
        DelegationSelectionTool dst = new DelegationSelectionTool(this.view());
        this.psp = new PropertySheet(500, 100);
        dst.setPropertyPanel(this.psp);
        return dst;
    }

    @Override
    protected void createMenus(JMenuBar mb) {
        mb.add(this.createFileMenu());
        mb.add(this.createEditMenu());
        mb.add(this.createAlignmentMenu());
        mb.add(this.createAttributesMenu());
        mb.add(this.createToolsMenu());
        mb.add(this.createWindowMenu());
        mb.add(this.createHelpMenu());
    }

    @Override
    protected Dimension defaultSize() {
        return new Dimension(this.width, this.height);
    }

    protected JMenu createToolsMenu() {
        this.tf = new TodoFrame(this);
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic(79);
        JMenuItem mi = new JMenuItem("Control Panel");
        mi.setMnemonic(67);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NeuralNetDrawing nnd = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet nn = nnd.getNeuralNet();
                JoonEdit.this.ps = JoonEdit.this.getMonitorPropertySheet(nn);
                JoonEdit.this.ps.setParameters(JoonEdit.this.parameters);
                JoonEdit.this.ps.update();
                JoonEdit.this.ps.setSize(330, 350);
                JoonEdit.this.ps.setVisible(true);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        menu.add(mi);
        mi = new JMenuItem("To Do List");
        mi.setMnemonic(84);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.tf.show();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Add Noise");
        mi.setMnemonic(65);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NeuralNetDrawing nnd = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet nn = nnd.getNeuralNet();
                nn.addNoise(0.2);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Randomize");
        mi.setMnemonic(82);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NeuralNetDrawing nnd = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet nn = nnd.getNeuralNet();
                nn.randomize(0.3);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Reset Input Streams");
        mi.setMnemonic(73);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NeuralNetDrawing nnd = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet nn = nnd.getNeuralNet();
                nn.resetInput();
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Macro Editor");
        mi.setMnemonic(77);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NeuralNetDrawing nnd = (NeuralNetDrawing)JoonEdit.this.drawing();
                NeuralNet nn = nnd.getNeuralNet();
                if (JoonEdit.this.macroEditor == null) {
                    if (nn.getMacroPlugin() == null) {
                        nn.setMacroPlugin(new MacroPlugin());
                    }
                    JoonEdit.this.macroEditor = new JMacroEditor(nn);
                }
                JoonEdit.this.macroEditor.setVisible(true);
                ((JooneStandardDrawingView)JoonEdit.this.view()).setModified(true);
            }
        });
        menu.add(mi);
        return menu;
    }

    protected MonitorPropertySheet getMonitorPropertySheet(NeuralNet nn) {
        if (this.ps == null) {
            Wrapper wr = new Wrapper(null, nn.getMonitor(), "Control Panel");
            this.ps = new MonitorPropertySheet(wr, nn);
        }
        return this.ps;
    }

    @Override
    protected JMenu createAlignmentMenu() {
        JooneCommandMenu menu = new JooneCommandMenu("Align");
        menu.setMnemonic(65);
        menu.add(new ToggleGridCommand("Toggle Snap to Grid", this.view(), new Point(4, 4)), new MenuShortcut(116));
        menu.addSeparator();
        menu.add(new AlignCommand("Left", this.view(), 0), new MenuShortcut(108));
        menu.add(new AlignCommand("Center", this.view(), 1), new MenuShortcut(99));
        menu.add(new AlignCommand("Right", this.view(), 2), new MenuShortcut(114));
        menu.addSeparator();
        menu.add(new AlignCommand("Top", this.view(), 3), new MenuShortcut(111));
        menu.add(new AlignCommand("Middle", this.view(), 4), new MenuShortcut(109));
        menu.add(new AlignCommand("Bottom", this.view(), 5), new MenuShortcut(98));
        return menu;
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        JMenuItem mi = new JMenuItem("New", new MenuShortcut(110).getKey());
        mi.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int n = JoonEdit.this.askForSave("Save changes to Neural Net?");
                if (n == 1 || !((JooneStandardDrawingView)JoonEdit.this.view()).isModified()) {
                    JoonEdit.this.promptNew();
                    return;
                }
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Open...", new MenuShortcut(111).getKey());
        mi.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int n = JoonEdit.this.askForSave("Save changes to Neural Net?");
                if (n == 1 || !((JooneStandardDrawingView)JoonEdit.this.view()).isModified()) {
                    JoonEdit.this.promptOpen();
                }
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Save", new MenuShortcut(115).getKey());
        mi.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (JoonEdit.this.latestStorageFormat != null && JoonEdit.this.getDrawingTitle() != null && !JoonEdit.this.getDrawingTitle().equals("")) {
                    JoonEdit.this.saveDrawing(JoonEdit.this.latestStorageFormat, JoonEdit.this.getDrawingTitle());
                } else {
                    JoonEdit.this.promptSaveAs();
                }
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Save As...", new MenuShortcut(97).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.promptSaveAs();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Export NeuralNet...", new MenuShortcut(101).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.promptSaveNeuralNet();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Export as XML...", new MenuShortcut(101).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.promptSaveAsXML();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Print...", new MenuShortcut(112).getKey());
        mi.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.print();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Page Setup...", new MenuShortcut(117).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.pageSetup();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Exit", new MenuShortcut(120).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JoonEdit.this.exit();
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createHelpMenu() {
        CommandMenu menu = new CommandMenu("Help");
        menu.setMnemonic(72);
        this.af = new AboutFrame(this);
        try {
            JMenuItem helpContents = new JMenuItem("Help Contents");
            helpContents.setAccelerator(KeyStroke.getKeyStroke("F1"));
            helpContents.setMnemonic(72);
            HelpSet hs = new HelpSet(null, HelpSet.findHelpSet(null, (String)"org/joone/edit/help_contents/joone.hs"));
            HelpBroker hb = hs.createHelpBroker();
            hb.setSize(new Dimension(800, 600));
            hb.setFont(new Font("Helvetica", 0, 10));
            helpContents.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
            hb.enableHelpKey((Component)this.getRootPane(), "top", null);
            menu.add(helpContents);
        }
        catch (Exception e) {
            log.warn("Exception thrown while creating the MenuHelp. Message is : " + e.getMessage(), e);
        }
        JMenu samples = this.createSamplesMenu();
        menu.add(samples);
        menu.addSeparator();
        JMenuItem mi = new JMenuItem("About Joone");
        mi.setMnemonic(65);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Rectangle r = JoonEdit.this.getBounds();
                JoonEdit.this.af.place(r.x + r.width / 2, r.y + r.height / 2);
                JoonEdit.this.af.setVisible(true);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu createSamplesMenu() {
        JMenu smp = new JMenu("Examples");
        JMenuItem smpi = new JMenuItem("SOM Image Tester");
        smpi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new SOMImageTester().setVisible(true);
            }
        });
        smp.add(smpi);
        return smp;
    }

    public void promptSaveNeuralNet() {
        JFileChooser saveDialog;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            saveDialog = this.createSaveFileChooser();
        } else {
            saveDialog = new JFileChooser(this.getDrawingTitle());
            saveDialog.setDialogTitle("Save File...");
        }
        this.getNetStorageFormatManager().registerFileFilters(saveDialog);
        if (saveDialog.showSaveDialog(this) == 0) {
            NetStorageFormat foundFormat = this.getNetStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
            if (foundFormat != null) {
                this.saveNeuralNet(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = null;
            } else {
                this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAsXML() {
        JFileChooser saveDialog;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            saveDialog = this.createSaveFileChooser();
        } else {
            saveDialog = new JFileChooser(this.getDrawingTitle());
            saveDialog.setDialogTitle("Save File...");
        }
        this.getXMLStorageFormatManager().registerFileFilters(saveDialog);
        if (saveDialog.showSaveDialog(this) == 0) {
            NetStorageFormat foundFormat = this.getXMLStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
            if (foundFormat != null) {
                this.saveNeuralNet(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = null;
            } else {
                this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
            }
        }
    }

    protected void saveNeuralNet(NetStorageFormat storeFormat, String file) {
        try {
            NeuralNetDrawing nnd = (NeuralNetDrawing)this.drawing();
            NeuralNet nn = nnd.getNeuralNet();
            nn.getMonitor().setExporting(true);
            storeFormat.store(file, nn);
            nn.getMonitor().setExporting(false);
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    protected JFileChooser createOpenFileChooser(String fn) {
        if (this.m_openDialog == null) {
            this.m_openDialog = new JooneFileChooser(fn);
        }
        return this.m_openDialog;
    }

    @Override
    protected JFileChooser createOpenFileChooser() {
        if (this.m_openDialog == null) {
            this.m_openDialog = new JooneFileChooser();
        }
        return this.m_openDialog;
    }

    @Override
    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new SerializationStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        return storageFormatManager;
    }

    public NetStorageFormatManager createNetStorageFormatManager() {
        NetStorageFormatManager storageFormatManager = new NetStorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new StandardNetStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        return storageFormatManager;
    }

    public NetStorageFormatManager createXMLStorageFormatManager() {
        NetStorageFormatManager storageFormatManager = new NetStorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new XMLNetStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        return storageFormatManager;
    }

    private void setNetStorageFormatManager(NetStorageFormatManager storageFormatManager) {
        this.fNetStorageFormatManager = storageFormatManager;
    }

    public NetStorageFormatManager getNetStorageFormatManager() {
        return this.fNetStorageFormatManager;
    }

    private void setXMLStorageFormatManager(NetStorageFormatManager storageFormatManager) {
        this.xNetStorageFormatManager = storageFormatManager;
    }

    public NetStorageFormatManager getXMLStorageFormatManager() {
        return this.xNetStorageFormatManager;
    }

    @Override
    protected Drawing createDrawing() {
        return new NeuralNetDrawing();
    }

    @Override
    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        JooneStandardDrawingView newView = new JooneStandardDrawingView(this, d.width, d.height);
        newView.setBackground(Color.lightGray);
        return newView;
    }

    @Override
    protected void loadDrawing(StorageFormat restoreFormat, String file) {
        try {
            Drawing restoredDrawing = restoreFormat.restore(file);
            if (restoredDrawing != null) {
                this.setDrawing(restoredDrawing);
                this.setDrawingTitle(file);
            } else {
                this.showStatus("Unknown file type: could not open file '" + file + "'");
            }
        }
        catch (IOException e) {
            this.showStatus("Error: " + e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JoonEdit window = new JoonEdit();
            window.open();
        } else {
            JoonEdit window = new JoonEdit(args[0]);
            window.open();
        }
    }

    @Override
    public void promptNew() {
        super.promptNew();
        if (this.psp != null) {
            this.psp.setVisible(false);
            this.psp = null;
        }
        if (this.ps != null) {
            this.ps.setVisible(false);
            this.ps = null;
        }
        NeuralNetDrawing nnd = (NeuralNetDrawing)this.drawing();
        nnd.setNeuralNet(new NeuralNet());
        LayerFigure.setNumLayers(0);
        if (this.macroEditor != null) {
            this.macroEditor.setVisible(false);
            this.macroEditor = null;
        }
        ((JooneStandardDrawingView)this.view()).setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        URL url = JoonEdit.class.getResource("/org/joone/images/splash.gif");
        ImageIcon img = new ImageIcon(url);
        JWindow frame = new JWindow();
        JLabel info = new JLabel("Initializing....", 0);
        info.setForeground(Color.black);
        try {
            JLabel pan = new JLabel(img){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setFont(new Font("Arial", 1, 10));
                    g2.drawString("Neural Network Editor", 15, 145);
                    g2.drawString("v " + JoonEdit.getVersion(), 45, 158);
                    g2.drawString("(c) " + Calendar.getInstance().get(1) + " Paolo Marrone", 10, 171);
                }
            };
            frame.getContentPane().add((Component)pan, "Center");
            pan.setLayout(new BorderLayout());
            pan.add((Component)info, "South");
            pan.setBorder(BorderFactory.createRaisedBevelBorder());
            info.setPreferredSize(new Dimension(pan.getWidth(), 24));
            frame.pack();
            JoonEdit.center(frame);
            frame.setVisible(true);
            info.setText("Starting...");
            super.open();
            this.readParameters();
            Iconkit kit = Iconkit.instance();
            if (kit == null) {
                throw new HJDError("Iconkit instance isn't set");
            }
            Image icn = kit.loadImageResource("/org/joone/images/JooneIcon.gif");
            this.setIconImage(icn);
            ((JooneStandardDrawingView)this.view()).setModified(false);
        }
        catch (Exception e) {
            info.setText(e.getMessage());
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        finally {
            frame.dispose();
        }
    }

    private void readParameters() {
        this.parameters = new EditorParameters();
        Vector elements = this.tParser.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            ToolElement te = (ToolElement)elements.elementAt(i);
            if (te.getType().compareToIgnoreCase("refreshing_rate") == 0) {
                this.parameters.setRefreshingRate(Integer.parseInt((String)te.getParam("value")));
            }
            if (te.getType().compareToIgnoreCase("http_proxy") != 0) continue;
            String hostname = (String)te.getParam("host");
            String port = (String)te.getParam("port");
            String userid = (String)te.getParam("userid");
            String passw = (String)te.getParam("passw");
            log.info("Using proxy: http://" + hostname + ":" + port);
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", hostname);
            System.setProperty("http.proxyPort", port);
            Authenticator.setDefault(new httpAuthenticateProxy(userid, passw));
        }
    }

    public static String getVersion() {
        return "2.0.0RC1";
    }

    public static int getNumericVersion() {
        return 2000000;
    }

    public static String getRecommendedEngineVersion() {
        return "1.2.5";
    }

    public static int getNumericRecommendedEngineVersion() {
        return 1002005;
    }

    @Override
    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.setMnemonic(84);
        JMenu mi = this.createColorMenu("Fill Color", "FillColor");
        mi.setMnemonic(70);
        menu.add(mi);
        mi = this.createColorMenu("Pen Color", "FrameColor");
        mi.setMnemonic(80);
        menu.add(mi);
        mi = this.createArrowMenu();
        mi.setMnemonic(65);
        menu.add(mi);
        menu.addSeparator();
        mi = this.createFontMenu();
        mi.setMnemonic(79);
        menu.add(mi);
        mi = this.createFontSizeMenu();
        mi.setMnemonic(83);
        menu.add(mi);
        mi = this.createFontStyleMenu();
        mi.setMnemonic(78);
        menu.add(mi);
        mi = this.createColorMenu("Text Color", "TextColor");
        mi.setMnemonic(84);
        menu.add(mi);
        return menu;
    }

    public JMenu createWindowMenu() {
        JMenu menu = new JMenu("Window");
        menu.setMnemonic(87);
        menu.add(this.createLookAndFeel());
        return menu;
    }

    public JMenu createLookAndFeel() {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        JMenu menu = new JMenu("Look and Feel");
        menu.setMnemonic(76);
        JMenuItem mi = null;
        for (int i = 0; i < lafs.length; ++i) {
            mi = new JMenuItem(lafs[i].getName());
            final String lnfClassName = lafs[i].getClassName();
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JoonEdit.this.newLookAndFeel(lnfClassName);
                }
            });
            menu.add(mi);
        }
        return menu;
    }

    private void newLookAndFeel(String landf) {
        try {
            UIManager.setLookAndFeel(landf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            log.warn("Exception thrown while adding a lookAndFeel. Message is : " + e.getMessage(), e);
        }
    }

    @Override
    protected JMenu createEditMenu() {
        JooneCommandMenu menu = new JooneCommandMenu("Edit");
        menu.setMnemonic(69);
        menu.add(new JooneCutCommand("Cut", this.view()), new MenuShortcut(116), KeyStroke.getKeyStroke(88, 2));
        menu.add(new JooneCopyCommand("Copy", this.view()), new MenuShortcut(99), KeyStroke.getKeyStroke(67, 2));
        menu.add(new PasteCommand("Paste", this.view()), new MenuShortcut(112), KeyStroke.getKeyStroke(86, 2));
        menu.addSeparator();
        menu.add(new JooneDuplicateCommand("Duplicate", this.view()), new MenuShortcut(100));
        menu.add(new DeleteCommand("Delete", this.view()), new MenuShortcut(101), KeyStroke.getKeyStroke("DELETE"));
        menu.addSeparator();
        menu.add(new GroupCommand("Group", this.view()), new MenuShortcut(103));
        menu.add(new UngroupCommand("Ungroup", this.view()), new MenuShortcut(117));
        menu.addSeparator();
        menu.add(new SendToBackCommand("Send to Back", this.view()), new MenuShortcut(115));
        menu.add(new BringToFrontCommand("Bring to Front", this.view()), new MenuShortcut(98));
        return menu;
    }

    @Override
    public void promptSaveAs() {
        JFileChooser saveDialog;
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            saveDialog = this.createSaveFileChooser();
        } else {
            saveDialog = new JFileChooser(this.getDrawingTitle());
            saveDialog.setDialogTitle("Save File...");
        }
        this.getStorageFormatManager().registerFileFilters(saveDialog);
        if (saveDialog.showSaveDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
            if (foundFormat != null) {
                this.saveDrawing(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = foundFormat;
            } else {
                this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
            }
        }
    }

    @Override
    public void promptOpen() {
        this.toolDone();
        if (this.getDrawingTitle() == null || this.getDrawingTitle().equals("")) {
            this.createOpenFileChooser();
        } else {
            this.createOpenFileChooser(this.getDrawingTitle());
            this.m_openDialog.setDialogTitle("Open File...");
        }
        this.getStorageFormatManager().registerFileFilters(this.m_openDialog);
        if (this.m_openDialog.showOpenDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(this.m_openDialog.getFileFilter());
            if (foundFormat != null) {
                this.promptNew();
                this.loadDrawing(foundFormat, this.m_openDialog.getSelectedFile().getAbsolutePath());
                this.latestStorageFormat = foundFormat;
            } else {
                this.showStatus("Not a valid file format: " + this.m_openDialog.getFileFilter().getDescription());
            }
        }
    }

    @Override
    protected void initDrawing() {
        super.initDrawing();
        this.latestStorageFormat = null;
    }

    @Override
    public void exit() {
        int n = this.askForSave("Save changes to Neural Net?");
        if (n == 1 || !((JooneStandardDrawingView)this.view()).isModified()) {
            this.writeIniFile();
            this.destroy();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    protected void destroy() {
        if (this.m_openDialog != null) {
            this.m_openDialog.saveDirectoryEntries();
        }
    }

    @Override
    protected void saveDrawing(StorageFormat storeFormat, String file) {
        try {
            this.setDrawingTitle(storeFormat.store(file, this.drawing()));
            ((JooneStandardDrawingView)this.view()).setModified(false);
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    protected int askForSave(String message) {
        int n = 2;
        if (((JooneStandardDrawingView)this.view()).isModified() && (n = JOptionPane.showConfirmDialog(this, message, "JoonEdit", 1)) == 0) {
            if (this.latestStorageFormat != null && this.getDrawingTitle() != null && !this.getDrawingTitle().equals("")) {
                this.saveDrawing(this.latestStorageFormat, this.getDrawingTitle());
            } else {
                this.promptSaveAs();
            }
        }
        return n;
    }

    private void readIniFile() {
        try {
            String lafName;
            File jooneHome = new File(System.getProperty("user.home") + File.separator + ".joone");
            if (!jooneHome.exists()) {
                jooneHome.mkdir();
            }
            this.iniFile = new IniFile(jooneHome + File.separator + INI_FILE_NAME);
            int state = Integer.parseInt(this.iniFile.getParameter("gui", "state", "0"));
            int x = Integer.parseInt(this.iniFile.getParameter("gui", "x", "0"));
            int y = Integer.parseInt(this.iniFile.getParameter("gui", "y", "0"));
            this.width = Integer.parseInt(this.iniFile.getParameter("gui", "width", "800"));
            this.height = Integer.parseInt(this.iniFile.getParameter("gui", "height", "600"));
            this.setLocation(x, y);
            if (state != -99) {
                this.setState(state);
            }
            if ((lafName = this.iniFile.getParameter("gui", "laf", null)) != null) {
                UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lafs.length; ++i) {
                    if (!lafName.toLowerCase().equals(lafs[i].getClassName().toLowerCase())) continue;
                    UIManager.setLookAndFeel(lafs[i].getClassName());
                    SwingUtilities.updateComponentTreeUI(this);
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception thrown reading writing config file. Message is : " + e.getMessage(), e);
        }
    }

    private void writeIniFile() {
        try {
            if (this.getState() == 0) {
                this.iniFile.setParameter("gui", "x", String.valueOf(this.getX()));
                this.iniFile.setParameter("gui", "y", String.valueOf(this.getY()));
                this.iniFile.setParameter("gui", "width", String.valueOf(this.getWidth()));
                this.iniFile.setParameter("gui", "height", String.valueOf(this.getHeight()));
            }
            this.iniFile.setParameter("gui", "state", String.valueOf(this.getState()));
            this.iniFile.setParameter("gui", "laf", UIManager.getLookAndFeel().getClass().getName());
        }
        catch (Exception e) {
            log.warn("Exception thrown while writing config file. Message is : " + e.getMessage(), e);
        }
    }

    private void pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.pageDialog(job.defaultPage());
    }

    private class httpAuthenticateProxy
    extends Authenticator {
        private String userid;
        private String passw;

        public httpAuthenticateProxy(String userid, String passw) {
            this.userid = userid;
            this.passw = passw;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userid, this.passw.toCharArray());
        }
    }
}

