/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Iconkit {
    private Hashtable fMap = new Hashtable(53);
    private Vector fRegisteredImages = new Vector(10);
    private Component fComponent;
    private static final int ID = 123;
    private static Iconkit fgIconkit = null;
    private static boolean fgDebug = false;

    public Iconkit(Component component) {
        this.fComponent = component;
        fgIconkit = this;
    }

    public static Iconkit instance() {
        return fgIconkit;
    }

    public void loadRegisteredImages(Component component) {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        MediaTracker tracker = new MediaTracker(component);
        Enumeration k = this.fRegisteredImages.elements();
        while (k.hasMoreElements()) {
            String fileName = (String)k.nextElement();
            if (this.basicGetImage(fileName) != null) continue;
            tracker.addImage(this.loadImage(fileName), 123);
        }
        this.fRegisteredImages.removeAllElements();
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerImage(String fileName) {
        this.fRegisteredImages.addElement(fileName);
    }

    public Image registerAndLoadImage(Component component, String fileName) {
        this.registerImage(fileName);
        this.loadRegisteredImages(component);
        return this.getImage(fileName);
    }

    public Image loadImage(String filename) {
        if (this.fMap.containsKey(filename)) {
            return (Image)this.fMap.get(filename);
        }
        Image image = this.loadImageResource(filename);
        if (image != null) {
            this.fMap.put(filename, image);
        }
        return image;
    }

    public Image loadImageResource(String resourcename) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = this.getClass().getResource(resourcename);
            if (fgDebug) {
                System.out.println(resourcename);
            }
            return toolkit.createImage((ImageProducer)url.getContent());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Image getImage(String filename) {
        Image image = this.basicGetImage(filename);
        if (image != null) {
            return image;
        }
        this.loadRegisteredImages(this.fComponent);
        return this.basicGetImage(filename);
    }

    private Image basicGetImage(String filename) {
        if (this.fMap.containsKey(filename)) {
            return (Image)this.fMap.get(filename);
        }
        return null;
    }
}

