/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    protected Connector fOriginalTarget;
    protected Figure fTarget = null;
    protected ConnectionFigure fConnection = (ConnectionFigure)this.owner();
    protected Point fStart;

    protected ChangeConnectionHandle(Figure owner) {
        super(owner);
    }

    protected abstract Connector target();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setPoint(int var1, int var2);

    protected Connector source() {
        if (this.target() == this.fConnection.start()) {
            return this.fConnection.end();
        }
        return this.fConnection.start();
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        this.fOriginalTarget = this.target();
        this.fStart = new Point(x, y);
        this.disconnect();
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = f;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.setPoint(p.x, p.y);
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target == null) {
            target = this.fOriginalTarget;
        }
        this.setPoint(x, y);
        this.connect(target);
        this.fConnection.updateConnection();
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
    }

    private Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && target != this.fOriginalTarget && !target.includes(this.owner()) && this.fConnection.canConnect(this.source().owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.green);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }
}

