/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.net;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.LocatorConnector;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class NodeFigure
extends TextFigure {
    private static final int BORDER = 6;
    private Vector fConnectors;
    private boolean fConnectorsVisible;

    public NodeFigure() {
        this.initialize();
        this.fConnectors = null;
    }

    @Override
    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        int d = 6;
        box.grow(d, d);
        return box;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.fConnectorsVisible) {
            Rectangle r = this.displayBox();
            int d = 4;
            r.grow(d, d);
            return r.contains(x, y);
        }
        return super.containsPoint(x, y);
    }

    private void drawBorder(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(this.getFrameColor());
        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        this.drawBorder(g);
        this.drawConnectors(g);
    }

    @Override
    public Vector handles() {
        LineConnection prototype = new LineConnection();
        Vector<LocatorHandle> handles = new Vector<LocatorHandle>();
        handles.addElement(new ConnectionHandle(this, RelativeLocator.east(), prototype));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.west(), prototype));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.south(), prototype));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.north(), prototype));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        return handles;
    }

    private void drawConnectors(Graphics g) {
        if (this.fConnectorsVisible) {
            Enumeration e = this.connectors().elements();
            while (e.hasMoreElements()) {
                ((Connector)e.nextElement()).draw(g);
            }
        }
    }

    @Override
    public void connectorVisibility(boolean isVisible) {
        this.fConnectorsVisible = isVisible;
        this.invalidate();
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return this.findConnector(x, y);
    }

    private Vector connectors() {
        if (this.fConnectors == null) {
            this.createConnectors();
        }
        return this.fConnectors;
    }

    private void createConnectors() {
        this.fConnectors = new Vector(4);
        this.fConnectors.addElement(new LocatorConnector(this, RelativeLocator.north()));
        this.fConnectors.addElement(new LocatorConnector(this, RelativeLocator.south()));
        this.fConnectors.addElement(new LocatorConnector(this, RelativeLocator.west()));
        this.fConnectors.addElement(new LocatorConnector(this, RelativeLocator.east()));
    }

    private Connector findConnector(int x, int y) {
        long min = Long.MAX_VALUE;
        Connector closest = null;
        Enumeration e = this.connectors().elements();
        while (e.hasMoreElements()) {
            Connector c = (Connector)e.nextElement();
            Point p2 = Geom.center(c.displayBox());
            long d = Geom.length2(x, y, p2.x, p2.y);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    private void initialize() {
        this.setText("node");
        Font fb = new Font("Helvetica", 1, 12);
        this.setFont(fb);
        this.createConnectors();
    }
}

