/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.samples.javadraw.FollowURLTool;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.StorableInput;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;

public class JavaDrawViewer
extends JApplet
implements DrawingEditor {
    private Drawing fDrawing;
    private Tool fTool;
    private StandardDrawingView fView;
    private Iconkit fIconkit;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.fView = new StandardDrawingView(this, 400, 370);
        this.getContentPane().add("Center", this.fView);
        this.fTool = new FollowURLTool(this.view(), this);
        this.fIconkit = new Iconkit(this);
        String filename = this.getParameter("Drawing");
        if (filename != null) {
            this.loadDrawing(filename);
            this.fView.setDrawing(this.fDrawing);
        } else {
            this.showStatus("Unable to load drawing");
        }
    }

    private void loadDrawing(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            StorableInput reader = new StorableInput(stream);
            this.fDrawing = (Drawing)reader.readStorable();
        }
        catch (IOException e) {
            this.fDrawing = new StandardDrawing();
            System.out.println("Error when Loading: " + e);
            this.showStatus("Error when Loading: " + e);
        }
    }

    @Override
    public DrawingView view() {
        return this.fView;
    }

    @Override
    public Drawing drawing() {
        return this.fDrawing;
    }

    @Override
    public Tool tool() {
        return this.fTool;
    }

    @Override
    public void toolDone() {
    }

    @Override
    public void selectionChanged(DrawingView view) {
    }
}

