/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.MDI_DrawApplication;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.InsertImageCommand;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.samples.javadraw.Animator;
import CH.ifa.draw.samples.javadraw.BouncingDrawing;
import CH.ifa.draw.samples.javadraw.MySelectionTool;
import CH.ifa.draw.samples.javadraw.URLTool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.util.Animatable;
import CH.ifa.draw.util.CommandMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class JavaDrawApp
extends MDI_DrawApplication {
    private Animator fAnimator;
    private static String fgSampleImagesPath = "CH/ifa/draw/samples/javadraw/sampleimages/";
    private static String fgSampleImagesResourcePath = "/" + fgSampleImagesPath;

    JavaDrawApp() {
        super("JHotDraw");
    }

    @Override
    protected DrawApplication createApplication() {
        return new JavaDrawApp();
    }

    @Override
    public void open() {
        super.open();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    @Override
    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        AbstractTool tool = new TextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool));
        tool = new ConnectedTextTool(this.view(), new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", tool));
        tool = new CreationTool(this.view(), new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new RoundRectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this.view(), new EllipseFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new CreationTool(this.view(), new LineFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this.view(), new LineConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this.view(), new ElbowConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new BorderTool(this.view());
        palette.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", tool));
    }

    @Override
    protected Tool createSelectionTool() {
        return new MySelectionTool(this.view());
    }

    @Override
    protected void createMenus(JMenuBar mb) {
        super.createMenus(mb);
        mb.add(this.createAnimationMenu());
        mb.add(this.createImagesMenu());
        mb.add(this.createWindowMenu());
    }

    protected JMenu createAnimationMenu() {
        JMenu menu = new JMenu("Animation");
        JMenuItem mi = new JMenuItem("Start Animation");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaDrawApp.this.startAnimation();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Stop Animation");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaDrawApp.this.endAnimation();
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createWindowMenu() {
        JMenu menu = new JMenu("Window");
        JMenuItem mi = new JMenuItem("New View");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaDrawApp.this.newView();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("New Window");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaDrawApp.this.newWindow();
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createImagesMenu() {
        CommandMenu menu = new CommandMenu("Images");
        File imagesDirectory = new File(fgSampleImagesPath);
        try {
            String[] list = imagesDirectory.list();
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                String path = fgSampleImagesResourcePath + name;
                menu.add(new InsertImageCommand(name, path, this.view()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menu;
    }

    @Override
    protected Drawing createDrawing() {
        return new BouncingDrawing();
    }

    public void startAnimation() {
        if (this.drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.drawing()), this.view());
            this.fAnimator.start();
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
        }
    }

    public static void main(String[] args) {
        JavaDrawApp window = new JavaDrawApp();
        window.open();
    }
}

