/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class RadiusHandle
extends AbstractHandle {
    private Point fRadius;
    private RoundRectangleFigure fOwner;
    private static final int OFFSET = 4;

    public RadiusHandle(RoundRectangleFigure owner) {
        super(owner);
        this.fOwner = owner;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        this.fRadius = this.fOwner.getArc();
        this.fRadius.x /= 2;
        this.fRadius.y /= 2;
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int dx = x - anchorX;
        int dy = y - anchorY;
        Rectangle r = this.fOwner.displayBox();
        int rx = Geom.range(0, r.width, 2 * (this.fRadius.x + dx));
        int ry = Geom.range(0, r.height, 2 * (this.fRadius.y + dy));
        this.fOwner.setArc(rx, ry);
    }

    @Override
    public Point locate() {
        Point radius = this.fOwner.getArc();
        Rectangle r = this.fOwner.displayBox();
        return new Point(r.x + radius.x / 2 + 4, r.y + radius.y / 2 + 4);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

