/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class ElbowHandle
extends AbstractHandle {
    private int fSegment;
    private int fLastX;
    private int fLastY;

    public ElbowHandle(LineConnection owner, int segment) {
        super(owner);
        this.fSegment = segment;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        this.fLastX = x;
        this.fLastY = y;
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point np2;
        Point np1;
        LineConnection line = this.ownerConnection();
        Point p1 = line.pointAt(this.fSegment);
        Point p2 = line.pointAt(this.fSegment + 1);
        int ddx = x - this.fLastX;
        int ddy = y - this.fLastY;
        if (this.isVertical(p1, p2)) {
            int cx = this.constrainX(p1.x + ddx);
            np1 = new Point(cx, p1.y);
            np2 = new Point(cx, p2.y);
        } else {
            int cy = this.constrainY(p1.y + ddy);
            np1 = new Point(p1.x, cy);
            np2 = new Point(p2.x, cy);
        }
        line.setPointAt(np1, this.fSegment);
        line.setPointAt(np2, this.fSegment + 1);
        this.fLastX = x;
        this.fLastY = y;
    }

    private boolean isVertical(Point p1, Point p2) {
        return p1.x == p2.x;
    }

    @Override
    public Point locate() {
        LineConnection line = this.ownerConnection();
        int segment = Math.min(this.fSegment, line.pointCount() - 2);
        Point p1 = line.pointAt(segment);
        Point p2 = line.pointAt(segment + 1);
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    private int constrainX(int x) {
        LineConnection line = this.ownerConnection();
        Figure startFigure = line.start().owner();
        Figure endFigure = line.end().owner();
        Rectangle start = startFigure.displayBox();
        Rectangle end2 = endFigure.displayBox();
        Insets i1 = startFigure.connectionInsets();
        Insets i2 = endFigure.connectionInsets();
        int r1x = start.x + i1.left;
        int r1width = start.width - i1.left - i1.right - 1;
        int r2x = end2.x + i2.left;
        int r2width = end2.width - i2.left - i2.right - 1;
        if (this.fSegment == 0) {
            x = Geom.range(r1x, r1x + r1width, x);
        }
        if (this.fSegment == line.pointCount() - 2) {
            x = Geom.range(r2x, r2x + r2width, x);
        }
        return x;
    }

    private int constrainY(int y) {
        LineConnection line = this.ownerConnection();
        Figure startFigure = line.start().owner();
        Figure endFigure = line.end().owner();
        Rectangle start = startFigure.displayBox();
        Rectangle end2 = endFigure.displayBox();
        Insets i1 = startFigure.connectionInsets();
        Insets i2 = endFigure.connectionInsets();
        int r1y = start.y + i1.top;
        int r1height = start.height - i1.top - i1.bottom - 1;
        int r2y = end2.y + i2.top;
        int r2height = end2.height - i2.top - i2.bottom - 1;
        if (this.fSegment == 0) {
            y = Geom.range(r1y, r1y + r1height, y);
        }
        if (this.fSegment == line.pointCount() - 2) {
            y = Geom.range(r2y, r2y + r2height, y);
        }
        return y;
    }

    private LineConnection ownerConnection() {
        return (LineConnection)this.owner();
    }
}

