/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class SweepSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;

    public SweepSolver(Matrix a) {
        super(a);
    }

    @Override
    public Vector solve(Vector b) {
        int i;
        this.ensureRHSIsCorrect(b);
        Matrix aa = this.a.copy();
        Vector bb = b.copy();
        Vector x = b.blankOfLength(aa.columns());
        for (i = 0; i < aa.rows() - 1; ++i) {
            int j;
            double maxItem = Math.abs(aa.get(i, i));
            int maxIndex = i;
            for (j = i + 1; j < aa.columns(); ++j) {
                double value = Math.abs(aa.get(j, i));
                if (!(value > maxItem)) continue;
                maxItem = value;
                maxIndex = j;
            }
            if (maxIndex != i) {
                aa.swapRows(maxIndex, i);
                bb.swapElements(i, maxIndex);
            }
            for (j = i + 1; j < aa.columns(); ++j) {
                double c = aa.get(j, i) / aa.get(i, i);
                for (int k = i; k < aa.columns(); ++k) {
                    aa.updateAt(j, k, Matrices.asMinusFunction(aa.get(i, k) * c));
                }
                bb.updateAt(j, Vectors.asMinusFunction(bb.get(i) * c));
            }
        }
        for (i = aa.rows() - 1; i >= 0; --i) {
            double acc = 0.0;
            for (int j = i + 1; j < aa.columns(); ++j) {
                acc += aa.get(i, j) * x.get(j);
            }
            x.set(i, (bb.get(i) - acc) / aa.get(i, i));
        }
        return x;
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.is(Matrices.TRIDIAGONAL_MATRIX);
    }
}

