/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.decomposition.AbstractDecompositor;
import org.la4j.decomposition.MatrixDecompositor;

public class RawQRDecompositor
extends AbstractDecompositor
implements MatrixDecompositor {
    public RawQRDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        Matrix qr = this.matrix.copy();
        Matrix r = this.matrix.blankOfShape(qr.columns(), qr.columns());
        for (int k = 0; k < qr.columns(); ++k) {
            int i;
            double norm = 0.0;
            for (i = k; i < qr.rows(); ++i) {
                norm = Math.hypot(norm, qr.get(i, k));
            }
            if (Math.abs(norm) > Matrices.EPS) {
                if (qr.get(k, k) < 0.0) {
                    norm = -norm;
                }
                for (i = k; i < qr.rows(); ++i) {
                    qr.updateAt(i, k, Matrices.asDivFunction(norm));
                }
                qr.updateAt(k, k, Matrices.INC_FUNCTION);
                for (int j = k + 1; j < qr.columns(); ++j) {
                    int i2;
                    double acc = 0.0;
                    for (i2 = k; i2 < qr.rows(); ++i2) {
                        acc += qr.get(i2, k) * qr.get(i2, j);
                    }
                    acc = -acc / qr.get(k, k);
                    for (i2 = k; i2 < qr.rows(); ++i2) {
                        qr.updateAt(i2, j, Matrices.asPlusFunction(acc * qr.get(i2, k)));
                    }
                }
            }
            r.set(k, k, -norm);
        }
        return new Matrix[]{qr, r};
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() >= matrix.columns();
    }
}

