/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas2D;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxDomOutputParser {
    protected mxICanvas2D canvas;
    protected transient Map<String, IElementHandler> handlers = new Hashtable<String, IElementHandler>();

    public mxDomOutputParser(mxICanvas2D canvas) {
        this.canvas = canvas;
        this.initHandlers();
    }

    public void read(Node node) {
        while (node != null) {
            Element elt;
            IElementHandler handler;
            if (node instanceof Element && (handler = this.handlers.get((elt = (Element)node).getNodeName())) != null) {
                handler.parseElement(elt);
            }
            node = node.getNextSibling();
        }
    }

    protected void initHandlers() {
        this.handlers.put("save", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.save();
            }
        });
        this.handlers.put("restore", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.restore();
            }
        });
        this.handlers.put("scale", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.scale(Double.parseDouble(elt.getAttribute("scale")));
            }
        });
        this.handlers.put("translate", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.translate(Double.parseDouble(elt.getAttribute("dx")), Double.parseDouble(elt.getAttribute("dy")));
            }
        });
        this.handlers.put("rotate", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.rotate(Double.parseDouble(elt.getAttribute("theta")), elt.getAttribute("flipH").equals("1"), elt.getAttribute("flipV").equals("1"), Double.parseDouble(elt.getAttribute("cx")), Double.parseDouble(elt.getAttribute("cy")));
            }
        });
        this.handlers.put("strokewidth", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setStrokeWidth(Double.parseDouble(elt.getAttribute("width")));
            }
        });
        this.handlers.put("strokecolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setStrokeColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("dashed", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setDashed(elt.getAttribute("dashed").equals("1"));
            }
        });
        this.handlers.put("dashpattern", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setDashPattern(elt.getAttribute("pattern"));
            }
        });
        this.handlers.put("linecap", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setLineCap(elt.getAttribute("cap"));
            }
        });
        this.handlers.put("linejoin", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setLineJoin(elt.getAttribute("join"));
            }
        });
        this.handlers.put("miterlimit", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setMiterLimit(Double.parseDouble(elt.getAttribute("limit")));
            }
        });
        this.handlers.put("fontsize", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontSize(Double.parseDouble(elt.getAttribute("size")));
            }
        });
        this.handlers.put("fontcolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("fontbackgroundcolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontBackgroundColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("fontbordercolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontBorderColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("fontfamily", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontFamily(elt.getAttribute("family"));
            }
        });
        this.handlers.put("fontstyle", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFontStyle(Integer.parseInt(elt.getAttribute("style")));
            }
        });
        this.handlers.put("alpha", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setAlpha(Double.parseDouble(elt.getAttribute("alpha")));
            }
        });
        this.handlers.put("fillalpha", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFillAlpha(Double.parseDouble(elt.getAttribute("alpha")));
            }
        });
        this.handlers.put("strokealpha", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setStrokeAlpha(Double.parseDouble(elt.getAttribute("alpha")));
            }
        });
        this.handlers.put("fillcolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setFillColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("shadowcolor", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setShadowColor(elt.getAttribute("color"));
            }
        });
        this.handlers.put("shadowalpha", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setShadowAlpha(Double.parseDouble(elt.getAttribute("alpha")));
            }
        });
        this.handlers.put("shadowoffset", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setShadowOffset(Double.parseDouble(elt.getAttribute("dx")), Double.parseDouble(elt.getAttribute("dy")));
            }
        });
        this.handlers.put("shadow", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setShadow(elt.getAttribute("enabled").equals("1"));
            }
        });
        this.handlers.put("gradient", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.setGradient(elt.getAttribute("c1"), elt.getAttribute("c2"), Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")), elt.getAttribute("direction"), Double.parseDouble(mxDomOutputParser.this.getValue(elt, "alpha1", "1")), Double.parseDouble(mxDomOutputParser.this.getValue(elt, "alpha2", "1")));
            }
        });
        this.handlers.put("rect", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.rect(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")));
            }
        });
        this.handlers.put("roundrect", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.roundrect(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")), Double.parseDouble(elt.getAttribute("dx")), Double.parseDouble(elt.getAttribute("dy")));
            }
        });
        this.handlers.put("ellipse", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.ellipse(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")));
            }
        });
        this.handlers.put("image", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.image(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")), elt.getAttribute("src"), elt.getAttribute("aspect").equals("1"), elt.getAttribute("flipH").equals("1"), elt.getAttribute("flipV").equals("1"));
            }
        });
        this.handlers.put("text", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.text(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")), Double.parseDouble(elt.getAttribute("w")), Double.parseDouble(elt.getAttribute("h")), elt.getAttribute("str"), elt.getAttribute("align"), elt.getAttribute("valign"), mxDomOutputParser.this.getValue(elt, "wrap", "").equals("1"), elt.getAttribute("format"), elt.getAttribute("overflow"), mxDomOutputParser.this.getValue(elt, "clip", "").equals("1"), Double.parseDouble(mxDomOutputParser.this.getValue(elt, "rotation", "0")), elt.getAttribute("dir"));
            }
        });
        this.handlers.put("begin", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.begin();
            }
        });
        this.handlers.put("move", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.moveTo(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")));
            }
        });
        this.handlers.put("line", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.lineTo(Double.parseDouble(elt.getAttribute("x")), Double.parseDouble(elt.getAttribute("y")));
            }
        });
        this.handlers.put("quad", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.quadTo(Double.parseDouble(elt.getAttribute("x1")), Double.parseDouble(elt.getAttribute("y1")), Double.parseDouble(elt.getAttribute("x2")), Double.parseDouble(elt.getAttribute("y2")));
            }
        });
        this.handlers.put("curve", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.curveTo(Double.parseDouble(elt.getAttribute("x1")), Double.parseDouble(elt.getAttribute("y1")), Double.parseDouble(elt.getAttribute("x2")), Double.parseDouble(elt.getAttribute("y2")), Double.parseDouble(elt.getAttribute("x3")), Double.parseDouble(elt.getAttribute("y3")));
            }
        });
        this.handlers.put("close", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.close();
            }
        });
        this.handlers.put("stroke", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.stroke();
            }
        });
        this.handlers.put("fill", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.fill();
            }
        });
        this.handlers.put("fillstroke", new IElementHandler(){

            @Override
            public void parseElement(Element elt) {
                mxDomOutputParser.this.canvas.fillAndStroke();
            }
        });
    }

    protected String getValue(Element elt, String name, String defaultValue) {
        String value = elt.getAttribute(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected static interface IElementHandler {
        public void parseElement(Element var1);
    }
}

