/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing.editor;

import com.mxgraph.examples.swing.editor.ShadowBorder;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JTableRenderer
extends JComponent {
    private static final long serialVersionUID = 2106746763664760745L;
    public static final String IMAGE_PATH = "/com/mxgraph/examples/swing/images/";
    protected static JTableRenderer dragSource = null;
    protected static int sourceRow = 0;
    protected Object cell;
    protected mxGraphComponent graphContainer;
    protected mxGraph graph;
    public JTable table;

    public JTableRenderer(final Object cell, final mxGraphComponent graphContainer) {
        this.cell = cell;
        this.graphContainer = graphContainer;
        this.graph = graphContainer.getGraph();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(ShadowBorder.getSharedInstance(), BorderFactory.createBevelBorder(0)));
        JPanel title = new JPanel();
        title.setBackground(new Color(149, 173, 239));
        title.setOpaque(true);
        title.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        title.setLayout(new BorderLayout());
        JLabel icon = new JLabel(new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/preferences.gif")));
        icon.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 1));
        title.add((Component)icon, "West");
        JLabel label = new JLabel(String.valueOf(this.graph.getLabel(cell)));
        label.setForeground(Color.WHITE);
        label.setFont(title.getFont().deriveFont(1, 11.0f));
        label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 2));
        title.add((Component)label, "Center");
        JPanel toolBar2 = new JPanel();
        toolBar2.setLayout(new FlowLayout(0, 1, 2));
        toolBar2.setOpaque(false);
        JButton button = new JButton(new AbstractAction("", new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/minimize.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTableRenderer.this.graph.foldCells(!JTableRenderer.this.graph.isCellCollapsed(cell), false, new Object[]{cell});
                ((JButton)e.getSource()).setIcon(new ImageIcon(JTableRenderer.class.getResource(JTableRenderer.IMAGE_PATH + (JTableRenderer.this.graph.isCellCollapsed(cell) ? "maximize.gif" : "minimize.gif"))));
            }
        });
        button.setPreferredSize(new Dimension(16, 16));
        button.setCursor(new Cursor(0));
        button.setToolTipText("Collapse/Expand");
        button.setOpaque(false);
        toolBar2.add(button);
        title.add((Component)toolBar2, "East");
        this.add((Component)title, "North");
        this.table = new MyTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setCursor(new Cursor(0));
        if (this.graph.getModel().getChildCount(cell) == 0) {
            scrollPane.getViewport().setBackground(Color.WHITE);
            this.setOpaque(true);
            this.add((Component)scrollPane, "Center");
        }
        scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                graphContainer.refresh();
            }
        });
        label = new JLabel(new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/resize.gif")));
        label.setCursor(new Cursor(6));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "East");
        this.add((Component)panel, "South");
        ResizeHandler resizeHandler = new ResizeHandler();
        label.addMouseListener(resizeHandler);
        label.addMouseMotionListener(resizeHandler);
        this.setMinimumSize(new Dimension(20, 30));
    }

    public static JTableRenderer getVertex(Component component) {
        while (component != null) {
            if (component instanceof JTableRenderer) {
                return (JTableRenderer)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public class MyTable
    extends JTable
    implements DropTargetListener {
        private static final long serialVersionUID = 5841175227984561071L;
        Object[][] data;
        String[] colNames = new String[]{"A", "B", "C", "D", "E"};

        public MyTable() {
            this.data = new Object[30][5];
            for (int i = 0; i < 30; ++i) {
                this.data[i][0] = new Boolean(false);
                this.data[i][1] = "Column " + i;
                this.data[i][2] = Math.random() > 0.5 ? new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/preferences.gif")) : null;
                this.data[i][3] = Math.random() > 0.5 ? new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/preferences.gif")) : null;
                this.data[i][4] = Math.random() > 0.5 ? new ImageIcon(JTableRenderer.class.getResource("/com/mxgraph/examples/swing/images/preferences.gif")) : null;
            }
            this.setModel(this.createModel());
            this.setTableHeader(null);
            this.setAutoscrolls(true);
            this.setGridColor(Color.WHITE);
            TableColumn column = this.getColumnModel().getColumn(0);
            column.setMaxWidth(20);
            column = this.getColumnModel().getColumn(2);
            column.setMaxWidth(12);
            column = this.getColumnModel().getColumn(3);
            column.setMaxWidth(12);
            column = this.getColumnModel().getColumn(4);
            column.setMaxWidth(12);
            this.setTransferHandler(new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    sourceRow = MyTable.this.getSelectedRow();
                    dragSource = JTableRenderer.this;
                    return new mxGraphTransferable(null, null, null);
                }
            });
            this.setDragEnabled(true);
            this.setDropTarget(new DropTarget(this, 3, this));
            this.setCursor(new Cursor(0));
        }

        @Override
        public DropTarget getDropTarget() {
            if (!((mxGraphTransferHandler)JTableRenderer.this.graphContainer.getTransferHandler()).isLocalDrag()) {
                return super.getDropTarget();
            }
            return null;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!((mxGraphTransferHandler)JTableRenderer.this.graphContainer.getTransferHandler()).isLocalDrag() && JTableRenderer.this != dragSource) {
                Point p = e.getLocation();
                int row = this.rowAtPoint(p);
                this.getSelectionModel().setSelectionInterval(row, row);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (dragSource != null) {
                e.acceptDrop(3);
                Point p = e.getLocation();
                int targetRow = this.rowAtPoint(p);
                Object edge = JTableRenderer.this.graph.insertEdge(null, null, null, JTableRenderer.dragSource.cell, JTableRenderer.this.cell, "sourceRow=" + sourceRow + ";targetRow=" + targetRow);
                JTableRenderer.this.graph.setSelectionCell(edge);
                dragSource = null;
                e.dropComplete(true);
            } else {
                e.rejectDrop();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        public TableModel createModel() {
            return new AbstractTableModel(){
                private static final long serialVersionUID = -3642207266816170738L;

                @Override
                public int getColumnCount() {
                    return MyTable.this.colNames.length;
                }

                @Override
                public int getRowCount() {
                    return MyTable.this.data.length;
                }

                @Override
                public String getColumnName(int col) {
                    return MyTable.this.colNames[col];
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return MyTable.this.data[row][col];
                }

                public Class<? extends Object> getColumnClass(int c) {
                    Object value = this.getValueAt(0, c);
                    return value != null ? value.getClass() : ImageIcon.class;
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 0;
                }

                @Override
                public void setValueAt(Object value, int row, int col) {
                    MyTable.this.data[row][col] = value;
                    this.fireTableCellUpdated(row, col);
                }
            };
        }
    }

    public class ResizeHandler
    implements MouseListener,
    MouseMotionListener {
        protected int index;

        public ResizeHandler() {
            this(7);
        }

        public ResizeHandler(int index) {
            this.index = index;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            mxCellHandler handler;
            if (!JTableRenderer.this.graph.isCellSelected(JTableRenderer.this.cell)) {
                JTableRenderer.this.graphContainer.selectCellForEvent(JTableRenderer.this.cell, e);
            }
            if ((handler = JTableRenderer.this.graphContainer.getSelectionCellsHandler().getHandler(JTableRenderer.this.cell)) != null) {
                handler.start(SwingUtilities.convertMouseEvent((Component)e.getSource(), e, JTableRenderer.this.graphContainer.getGraphControl()), this.index);
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableRenderer.this.graphContainer.getGraphControl().dispatchEvent(SwingUtilities.convertMouseEvent((Component)e.getSource(), e, JTableRenderer.this.graphContainer.getGraphControl()));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JTableRenderer.this.graphContainer.getGraphControl().dispatchEvent(SwingUtilities.convertMouseEvent((Component)e.getSource(), e, JTableRenderer.this.graphContainer.getGraphControl()));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

