/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.SlotSet;
import net.sourceforge.plantuml.ugraphic.TextLimitFinder;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SlotFinderX
implements UGraphic {
    private final SlotSet xslot;
    private final SlotSet yslot;
    private final StringBounder stringBounder;
    private final UTranslate translate;

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new SlotFinderX(this.stringBounder, this.xslot, this.yslot, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke) {
            return new SlotFinderX(this);
        }
        if (change instanceof UChangeBackColor) {
            return new SlotFinderX(this);
        }
        if (change instanceof UChangeColor) {
            return new SlotFinderX(this);
        }
        throw new UnsupportedOperationException();
    }

    public SlotFinderX(StringBounder stringBounder) {
        this(stringBounder, new SlotSet(), new SlotSet(), new UTranslate());
    }

    private SlotFinderX(StringBounder stringBounder, SlotSet xslot, SlotSet yslot, UTranslate translate) {
        this.stringBounder = stringBounder;
        this.xslot = xslot;
        this.yslot = yslot;
        this.translate = translate;
    }

    private SlotFinderX(SlotFinderX other) {
        this(other.stringBounder, other.xslot, other.yslot, other.translate);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof UPolygon) {
            this.drawPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof UEmpty) {
            this.drawEmpty(x, y, (UEmpty)shape);
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        this.xslot.addSlot(x, x + shape.getWidth());
        this.yslot.addSlot(y, y + shape.getHeight());
    }

    private void drawText(double x, double y, UText shape) {
        TextLimitFinder finder = new TextLimitFinder(this.stringBounder, false);
        finder.apply(new UTranslate(x, y)).draw(shape);
        this.xslot.addSlot(finder.getMinX(), finder.getMaxX());
        this.yslot.addSlot(finder.getMinY(), finder.getMaxY());
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        this.xslot.addSlot(x, x + shape.getWidth());
        this.yslot.addSlot(y, y + shape.getHeight());
    }

    private void drawPolygon(double x, double y, UPolygon shape) {
        this.xslot.addSlot(x + shape.getMinX(), x + shape.getMaxX());
        this.yslot.addSlot(y + shape.getMinY(), y + shape.getMaxY());
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        this.xslot.addSlot(x, x + shape.getWidth());
        this.yslot.addSlot(y, y + shape.getHeight());
    }

    @Override
    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    public SlotSet getXSlotSet() {
        return this.xslot;
    }

    public SlotSet getYSlotSet() {
        return this.yslot;
    }

    @Override
    public void flushUg() {
    }
}

