/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperTransparentWrapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPattern;
import net.sourceforge.plantuml.ugraphic.UScale;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class AbstractCommonUGraphic
implements UGraphic {
    private UStroke stroke = new UStroke();
    private UPattern pattern = UPattern.FULL;
    private boolean hidden = false;
    private HtmlColor backColor = null;
    private HtmlColor color = null;
    private UTranslate translate = new UTranslate();
    private final ColorMapper colorMapper;
    private UClip clip;
    private double scale = 1.0;

    @Override
    public UGraphic apply(UChange change) {
        AbstractCommonUGraphic copy = this.copyUGraphic();
        if (change instanceof UTranslate) {
            copy.translate = ((UTranslate)change).scaled(this.scale).compose(copy.translate);
        } else if (change instanceof UClip) {
            copy.clip = (UClip)change;
            copy.clip = copy.clip.translate(this.getTranslateX(), this.getTranslateY());
        } else if (change instanceof UStroke) {
            copy.stroke = (UStroke)change;
        } else if (change instanceof UPattern) {
            copy.pattern = (UPattern)change;
        } else if (change instanceof UHidden) {
            copy.hidden = change == UHidden.HIDDEN;
        } else if (change instanceof UChangeBackColor) {
            copy.backColor = ((UChangeBackColor)change).getBackColor();
        } else if (change instanceof UChangeColor) {
            copy.color = ((UChangeColor)change).getColor();
        } else if (change instanceof UScale) {
            double factor = ((UScale)change).getScale();
            copy.scale = this.scale * factor;
        }
        return copy;
    }

    public final UClip getClip() {
        return this.clip;
    }

    public AbstractCommonUGraphic(ColorMapper colorMapper) {
        this.colorMapper = colorMapper;
    }

    protected AbstractCommonUGraphic(AbstractCommonUGraphic other) {
        this.colorMapper = other.colorMapper;
        this.translate = other.translate;
        this.clip = other.clip;
        this.stroke = other.stroke;
        this.pattern = other.pattern;
        this.hidden = other.hidden;
        this.color = other.color;
        this.backColor = other.backColor;
        this.scale = other.scale;
    }

    protected abstract AbstractCommonUGraphic copyUGraphic();

    @Override
    public final UParam getParam() {
        return new UParam(){

            @Override
            public boolean isHidden() {
                return AbstractCommonUGraphic.this.hidden;
            }

            @Override
            public UStroke getStroke() {
                return AbstractCommonUGraphic.this.stroke;
            }

            @Override
            public HtmlColor getColor() {
                return AbstractCommonUGraphic.this.color;
            }

            @Override
            public HtmlColor getBackcolor() {
                return AbstractCommonUGraphic.this.backColor;
            }

            @Override
            public UPattern getPattern() {
                return AbstractCommonUGraphic.this.pattern;
            }

            @Override
            public double getScale() {
                return AbstractCommonUGraphic.this.scale;
            }
        };
    }

    protected final double getTranslateX() {
        return this.translate.getDx();
    }

    protected final double getTranslateY() {
        return this.translate.getDy();
    }

    @Override
    public final ColorMapper getColorMapper() {
        return new ColorMapperTransparentWrapper(this.colorMapper);
    }

    @Override
    public void flushUg() {
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }
}

