/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Clock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;

public class TimeTickBuilder {
    private static final String WITHOUT_AROBASE = "(\\+?)(\\d+\\.?\\d*)";
    private static final String WITH_AROBASE = "@(\\+?)(\\d+\\.?\\d*)";

    public static RegexLeaf expressionAtWithoutArobase(String name) {
        return new RegexLeaf(name, WITHOUT_AROBASE);
    }

    public static RegexLeaf expressionAtWithArobase(String name) {
        return new RegexLeaf(name, WITH_AROBASE);
    }

    public static RegexLeaf optionalExpressionAtWithArobase(String name) {
        return new RegexLeaf(name, "(?:@(\\+?)(\\d+\\.?\\d*))?");
    }

    public static TimeTick parseTimeTick(String name, RegexResult arg, Clock clock) {
        String number = arg.get(name, 1);
        if (number == null) {
            return clock.getNow();
        }
        boolean isRelative = "+".equals(arg.get(name, 0));
        BigDecimal value = new BigDecimal(number);
        if (isRelative) {
            value = clock.getNow().getTime().add(value);
        }
        return new TimeTick(value);
    }
}

