/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandNote
extends SingleLineCommand2<TimingDiagram> {
    public CommandNote() {
        super(CommandNote.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("[%s]*note[%s]+"), new RegexLeaf("POSITION", "(top|bottom)[%s]+of[%s]+"), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.+)"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, RegexResult arg) {
        String code = arg.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = Display.getWithNewlines(arg.get("NOTE", 0));
        TimeTick now = diagram.getNow();
        player.addNote(now, note, Position.fromString(arg.get("POSITION", 0)));
        return CommandExecutionResult.ok();
    }
}

