/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;

public class SvekUtils {
    private static final String pointsString = "points=\"";

    public static void traceString(File f, String text) throws IOException {
        try (PrintWriter pw = null;){
            Log.info("Creating intermediate file " + f.getAbsolutePath());
            pw = new PrintWriter(new FileWriter(f));
            pw.print(text);
        }
    }

    public static List<Point2D.Double> extractPointsList(String svg, int starting, double yDelta) {
        int p2 = svg.indexOf(pointsString, starting);
        int p3 = svg.indexOf("\"", p2 + pointsString.length());
        String points = svg.substring(p2 + pointsString.length(), p3);
        List<Point2D.Double> pointsList = SvekUtils.getPoints(points, yDelta);
        return pointsList;
    }

    public static List<Point2D.Double> extractD(String svg, int starting, double yDelta) {
        int p2 = svg.indexOf("d=\"", starting);
        int p3 = svg.indexOf("\"", p2 + "d=\"".length());
        String points = svg.substring(p2 + "d=\"".length(), p3);
        List<Point2D.Double> pointsList = SvekUtils.getPoints(points, yDelta);
        return pointsList;
    }

    public static int getIndexFromColor(String svg, int color) {
        String s = "stroke=\"" + StringUtils.goLowerCase(StringUtils.getAsHtml(color)) + "\"";
        int idx = svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        s = ";stroke:" + StringUtils.goLowerCase(StringUtils.getAsHtml(color)) + ";";
        idx = svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        s = "fill=\"" + StringUtils.goLowerCase(StringUtils.getAsHtml(color)) + "\"";
        idx = svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        return -1;
    }

    public static double getValue(String svg, int starting, String varName) {
        String varNameString = varName + "=\"";
        int p1 = svg.indexOf(varNameString, starting);
        if (p1 == -1) {
            throw new IllegalStateException();
        }
        int p2 = svg.indexOf(34, p1 += varNameString.length());
        return Double.parseDouble(svg.substring(p1, p2));
    }

    public static double getMaxX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x > result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    public static double getMinX(List<Point2D.Double> points) {
        double result = points.get((int)0).x;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).x < result)) continue;
            result = points.get((int)i).x;
        }
        return result;
    }

    public static Point2D.Double getMinXY(List<Point2D.Double> points) {
        return new Point2D.Double(SvekUtils.getMinX(points), SvekUtils.getMinY(points));
    }

    public static double getMaxY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y > result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    public static double getMinY(List<Point2D.Double> points) {
        double result = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            if (!(points.get((int)i).y < result)) continue;
            result = points.get((int)i).y;
        }
        return result;
    }

    private static List<Point2D.Double> getPoints(String points, double yDelta) {
        try {
            ArrayList<Point2D.Double> result = new ArrayList<Point2D.Double>();
            StringTokenizer st = new StringTokenizer(points, " MC");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(t, ",");
                double x = Double.parseDouble(st2.nextToken());
                double y = Double.parseDouble(st2.nextToken()) + yDelta;
                result.add(new Point2D.Double(x, y));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    public static void println(StringBuilder sb) {
        sb.append('\n');
    }

    public static String pixelToInches(double pixel) {
        double v = pixel / 72.0;
        return String.format(Locale.US, "%6.6f", v);
    }

    static class PointListIterator
    implements Iterator<List<Point2D.Double>> {
        private final String text;
        private final double yDelta;
        private int pos = 0;

        public static PointListIterator create(String text, double yDelta, int lineColor) {
            PointListIterator result = new PointListIterator(text, yDelta);
            int idx = SvekUtils.getIndexFromColor(text, lineColor);
            if (idx == -1) {
                result.pos = -1;
            }
            return result;
        }

        public PointListIterator cloneMe() {
            PointListIterator result = new PointListIterator(this.text, this.yDelta);
            result.pos = this.pos;
            return result;
        }

        private PointListIterator(String text, double yDelta) {
            this.text = text;
            this.yDelta = yDelta;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public List<Point2D.Double> next() {
            if (this.pos == -1) {
                return Collections.emptyList();
            }
            try {
                List<Point2D.Double> result = SvekUtils.extractPointsList(this.text, this.pos, this.yDelta);
                this.pos = this.text.indexOf(SvekUtils.pointsString, this.pos) + SvekUtils.pointsString.length() + 1;
                return result;
            }
            catch (StringIndexOutOfBoundsException e) {
                Log.error("Error " + e);
                return Collections.emptyList();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

