/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.FillRoundShape;
import net.sourceforge.plantuml.skin.bluemodern.ShadowShape;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernParticipant
extends AbstractTextualComponent {
    private final int shadowview = 3;
    private final HtmlColor blue1;
    private final HtmlColor blue2;

    public ComponentBlueModernParticipant(HtmlColor blue1, HtmlColor blue2, FontConfiguration font, Display stringsToDisplay, ISkinSimple spriteContainer) {
        super(LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 7, 7, 7, spriteContainer, false, null, null);
        this.blue1 = blue1;
        this.blue2 = blue2;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        ShadowShape shadowShape = new ShadowShape(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), 10.0);
        UGraphic ugShadow = ug.apply(new UTranslate(3.0, 3.0)).apply(new UChangeColor(null));
        shadowShape.drawU(ugShadow);
        FillRoundShape shape = new FillRoundShape(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.blue1, this.blue2, 10.0);
        shape.drawU(ug);
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

