/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.FillRoundShape;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernDivider
extends AbstractTextualComponent {
    private final HtmlColor background1;
    private final HtmlColor background2;
    private final HtmlColor borderColor;

    public ComponentBlueModernDivider(FontConfiguration font, HtmlColor background1, HtmlColor background2, HtmlColor borderColor, Display stringsToDisplay, ISkinSimple spriteContainer) {
        super(LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 4, 4, 4, spriteContainer, false, null, null);
        this.background1 = background1;
        this.background2 = background2;
        this.borderColor = borderColor;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        double textWidth = this.getTextWidth(stringBounder);
        double textHeight = this.getTextHeight(stringBounder);
        double deltaX = 6.0;
        double xpos = (dimensionToUse.getWidth() - textWidth - 6.0) / 2.0;
        double ypos = (dimensionToUse.getHeight() - textHeight) / 2.0;
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug = ug.apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        ug = ug.apply(new UStroke(2.0));
        ug.apply(new UTranslate(0.0, dimensionToUse.getHeight() / 2.0 - 1.0)).draw(new ULine(dimensionToUse.getWidth(), 0.0));
        ug.apply(new UTranslate(0.0, dimensionToUse.getHeight() / 2.0 + 2.0)).draw(new ULine(dimensionToUse.getWidth(), 0.0));
        FillRoundShape shape = new FillRoundShape(textWidth + 6.0, textHeight, this.background1, this.background2, 5.0);
        shape.drawU(ug.apply(new UTranslate(xpos, ypos)));
        ug = ug.apply(new UChangeColor(this.borderColor));
        ug = ug.apply(new UChangeBackColor(null));
        ug.apply(new UTranslate(xpos, ypos)).draw(new URectangle(textWidth + 6.0, textHeight, 5.0, 5.0));
        ug = ug.apply(new UStroke());
        textBlock.drawU(ug.apply(new UTranslate(xpos + 6.0, ypos + (double)this.getMarginY())));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

