/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;

abstract class Step1Abstract {
    private final StringBounder stringBounder;
    private final DrawableSet drawingSet;
    private final AbstractMessage message;
    private Frontier freeY2;
    private ArrowConfiguration config;
    private final List<Component> notes = new ArrayList<Component>();
    private ParticipantRange range;

    Step1Abstract(ParticipantRange range, StringBounder stringBounder, AbstractMessage message, DrawableSet drawingSet, Frontier freeY2) {
        if (freeY2 == null) {
            throw new IllegalArgumentException();
        }
        this.range = range;
        this.stringBounder = stringBounder;
        this.message = message;
        this.freeY2 = freeY2;
        this.drawingSet = drawingSet;
    }

    protected final ParticipantRange getParticipantRange() {
        return this.range;
    }

    abstract Frontier prepareMessage(ConstraintSet var1, InGroupablesStack var2);

    protected final ArrowConfiguration getConfig() {
        return this.config;
    }

    protected final void setConfig(ArrowConfiguration config) {
        this.config = config.withThickness(this.drawingSet.getArrowThickness());
    }

    protected final List<Component> getNotes() {
        return this.notes;
    }

    protected final void addNote(Component note) {
        this.notes.add(note);
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final AbstractMessage getMessage() {
        return this.message;
    }

    protected final DrawableSet getDrawingSet() {
        return this.drawingSet;
    }

    protected final Frontier getFreeY() {
        return this.freeY2;
    }

    protected final void incFreeY(double v) {
        this.freeY2 = this.freeY2.add(v, this.range);
    }

    protected final NoteBox createNoteBox(StringBounder stringBounder, Arrow arrow, Component noteComp, NoteOnMessage noteOnMessage) {
        LivingParticipantBox p = arrow.getParticipantAt(stringBounder, noteOnMessage.getNotePosition());
        NoteBox noteBox = new NoteBox(arrow.getStartingY(), noteComp, p, null, noteOnMessage.getNotePosition(), noteOnMessage.getUrlNote());
        if (arrow instanceof MessageSelfArrow && noteOnMessage.getNotePosition() == NotePosition.RIGHT) {
            noteBox.pushToRight(arrow.getPreferredWidth(stringBounder));
        }
        return noteBox;
    }
}

