/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;

public class TaskInstant
implements Complement {
    private final Task task;
    private final TaskAttribute attribute;
    private final int delta;

    public TaskInstant(Task task, TaskAttribute attribute) {
        this(task, attribute, 0);
    }

    private TaskInstant(Task task, TaskAttribute attribute, int delta) {
        this.task = task;
        this.attribute = attribute;
        this.delta = delta;
        if (attribute != TaskAttribute.START && attribute != TaskAttribute.END) {
            throw new IllegalArgumentException();
        }
    }

    public TaskInstant withDelta(int newDelta) {
        return new TaskInstant(this.task, this.attribute, newDelta);
    }

    private Instant manageDelta(Instant value) {
        int i;
        if (this.delta > 0) {
            for (i = 0; i < this.delta; ++i) {
                value = value.increment();
            }
        }
        if (this.delta < 0) {
            for (i = 0; i < -this.delta; ++i) {
                value = value.decrement();
            }
        }
        return value;
    }

    public Instant getInstantPrecise() {
        if (this.attribute == TaskAttribute.START) {
            return this.manageDelta(this.task.getStart());
        }
        if (this.attribute == TaskAttribute.END) {
            return this.manageDelta(this.task.getEnd().increment());
        }
        throw new IllegalStateException();
    }

    public Instant getInstantTheorical() {
        if (this.attribute == TaskAttribute.START) {
            return this.manageDelta(this.task.getStart());
        }
        if (this.attribute == TaskAttribute.END) {
            return this.manageDelta(this.task.getEnd());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.attribute.toString() + " of " + this.task;
    }

    public final Task getTask() {
        return this.task;
    }

    public final TaskAttribute getAttribute() {
        return this.attribute;
    }
}

