/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericType;

class NumericNumber
implements Numeric {
    private final int value;

    public NumericNumber(int v) {
        this.value = v;
    }

    @Override
    public Numeric add(Numeric other) {
        if (other.getNumericType() != this.getNumericType()) {
            throw new IllegalArgumentException();
        }
        return new NumericNumber(this.value + ((NumericNumber)other).value);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.NUMBER;
    }

    public int getIntValue() {
        return this.value;
    }

    public String toString() {
        return "Number:" + this.value;
    }

    @Override
    public int compareTo(Numeric other) {
        NumericNumber this2 = (NumericNumber)other;
        if (this2.value > this.value) {
            return -1;
        }
        if (this2.value < this.value) {
            return 1;
        }
        return 0;
    }
}

