/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flashcode;

import ext.plantuml.com.google.zxing.BarcodeFormat;
import ext.plantuml.com.google.zxing.EncodeHintType;
import ext.plantuml.com.google.zxing.WriterException;
import ext.plantuml.com.google.zxing.client.j2se.MatrixToImageWriter;
import ext.plantuml.com.google.zxing.common.BitMatrix;
import ext.plantuml.com.google.zxing.qrcode.QRCodeWriter;
import ext.plantuml.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;

public class FlashCodeUtilsZxing
implements FlashCodeUtils {
    @Override
    public BufferedImage exportFlashcode(String s) {
        try {
            QRCodeWriter writer = new QRCodeWriter();
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF8");
            boolean multiple = true;
            BitMatrix bit = writer.encode(s, BarcodeFormat.QR_CODE, 1, hints);
            return MatrixToImageWriter.toBufferedImage(bit);
        }
        catch (WriterException e) {
            Log.debug("Cannot create flashcode " + e);
            return null;
        }
    }
}

