/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class CommandPackageWithUSymbol
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackageWithUSymbol() {
        super(CommandPackageWithUSymbol.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(package|rectangle|node|artifact|folder|file|frame|cloud|database|storage|component|card|together)"), new RegexLeaf("[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "([%g][^%g]+[%g])"), new RegexLeaf("STEREOTYPE1", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE1", "([^#%s{}]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^#%s{}%g]+)"), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("DISPLAY2", "([%g][^%g]+[%g])")), new RegexConcat(new RegexLeaf("DISPLAY3", "([^#%s{}%g]+)"), new RegexLeaf("STEREOTYPE3", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE3", "([^#%s{}%g]+)")), new RegexLeaf("CODE8", "([%g][^%g]+[%g])"), new RegexLeaf("CODE9", "([^#%s{}%g]*)")), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandPackageWithUSymbol.color().getRegex(), new RegexLeaf("[%s]*\\{$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, RegexResult arg) {
        String display;
        Code code;
        String codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("CODE", 0));
        String displayRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("DISPLAY", 0));
        if (codeRaw.length() == 0) {
            code = UniqueSequence.getCode("##");
            display = null;
        } else {
            code = Code.of(codeRaw);
            display = displayRaw == null ? code.getFullName() : displayRaw;
        }
        IGroup currentPackage = diagram.getCurrentGroup();
        IGroup p = diagram.getOrCreateGroup(code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage);
        p.setUSymbol(USymbol.getFromString(arg.get("SYMBOL", 0)));
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype, false));
        }
        Colors colors = CommandPackageWithUSymbol.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

