/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileIfWithDiamonds
extends FtileIfNude {
    private final double SUPP_WITH = 20.0;
    protected final Ftile diamond1;
    protected final Ftile diamond2;

    public FtileIfWithDiamonds(Ftile diamond1, Ftile tile1, Ftile tile2, Ftile diamond2, Swimlane in, StringBounder stringBounder) {
        super(tile1, tile2, in);
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.diamond1, this.diamond2, this.tile1, this.tile2);
    }

    public int getYdelta1a(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 20;
        }
        return 10;
    }

    public int getYdelta1b(StringBounder stringBounder) {
        if (this.getSwimlanes().size() > 1) {
            return 10;
        }
        return this.hasTwoBranches(stringBounder) ? 6 : 0;
    }

    @Override
    protected double withInner(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        return Math.max(super.withInner(stringBounder), dim1.getWidth() + 20.0);
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimNude = super.calculateDimensionInternalSlow(stringBounder);
        FtileGeometry all = dim1.appendBottom(dimNude).appendBottom(dim2);
        return all.addDim(0.0, this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder));
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        super.drawU(ug);
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    protected UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate1(stringBounder).compose(new UTranslate(0.0, dimDiamond1.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    @Override
    protected UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return super.getTranslate2(stringBounder).compose(new UTranslate(0.0, dimDiamond1.getHeight() + (double)this.getYdelta1a(stringBounder)));
    }

    protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
        double x2 = dimTotal.getLeft() - dimDiamond2.getWidth() / 2.0;
        return new UTranslate(x2, y2);
    }

    public double computeMarginNeedForBranchLabe1(StringBounder stringBounder, Dimension2D label1) {
        double dxDiamond;
        double widthLabelBranch1 = label1.getWidth();
        double diff = widthLabelBranch1 - (dxDiamond = this.getTranslateDiamond1(stringBounder).getDx());
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }

    public double computeMarginNeedForBranchLabe2(StringBounder stringBounder, Dimension2D label2) {
        double widthLabelBranch2 = label2.getWidth();
        double theoricalEndNeeded = this.getTranslateDiamond1(stringBounder).getDx() + this.diamond1.calculateDimension(stringBounder).getWidth() + widthLabelBranch2;
        double diff = theoricalEndNeeded - this.calculateDimension(stringBounder).getWidth();
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }

    public double computeVerticalMarginNeedForBranchs(StringBounder stringBounder, Dimension2D label1, Dimension2D label2) {
        FtileGeometry dimDiamond1;
        double dyDiamond;
        double heightLabels = Math.max(label1.getHeight(), label2.getHeight());
        double diff = heightLabels - (dyDiamond = (dimDiamond1 = this.diamond1.calculateDimension(stringBounder)).getHeight());
        if (diff > 0.0) {
            return diff;
        }
        return 0.0;
    }
}

