/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.Version;

public class BlockUml {
    private final List<CharSequence2> data;
    private final int startLine;
    private Diagram system;
    private final Defines localDefines;

    BlockUml(String ... strings) {
        this(BlockUml.convert(strings), 0, Defines.createEmpty());
    }

    public String getEncodedUrl() throws IOException {
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        String source = this.getDiagram().getSource().getPlainString();
        String encoded = transcoder.encode(source);
        return encoded;
    }

    public String getFlashData() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence2 line : this.data) {
            sb.append(line);
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<CharSequence2> convert(String ... strings) {
        return BlockUml.convert(Arrays.asList(strings));
    }

    public static List<CharSequence2> convert(List<String> strings) {
        ArrayList<CharSequence2> result = new ArrayList<CharSequence2>();
        LineLocationImpl location = new LineLocationImpl("block", null);
        for (String s : strings) {
            location = location.oneLineRead();
            result.add(new CharSequence2Impl(s, location));
        }
        return result;
    }

    public BlockUml(List<CharSequence2> strings, int startLine, Defines defines) {
        this.startLine = startLine;
        this.localDefines = defines;
        CharSequence2 s0 = strings.get(0).trin();
        if (!StartUtils.startsWithSymbolAnd("start", s0)) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence2>(strings);
    }

    public String getFileOrDirname() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher2 m = StartUtils.patternFilename.matcher(StringUtils.trin(this.data.get(0).toString()));
        boolean ok = m.find();
        if (!ok) {
            return null;
        }
        String result = m.group(1);
        int x = result.indexOf(44);
        if (x != -1) {
            result = result.substring(0, x);
        }
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (result.startsWith("file://")) {
            result = result.substring("file://".length());
        }
        result = result.replaceAll("\\.\\w\\w\\w$", "");
        return result;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = new PSystemBuilder().createPSystem(this.data, this.startLine);
        }
        return this.system;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final List<CharSequence2> getData() {
        return this.data;
    }

    private String internalEtag() {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            for (CharSequence charSequence : this.data) {
                msgDigest.update(charSequence.toString().getBytes("UTF-8"));
            }
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "NOETAG";
        }
    }

    public String etag() {
        return Version.etag() + this.internalEtag();
    }

    public long lastModified() {
        return Version.compileTime() / 1000L / 60L * 1000L * 60L + (long)Version.beta() * 1000L * 3600L;
    }

    public boolean isStartDef(String name) {
        String signature = "@startdef(id=" + name + ")";
        return this.data.get(0).toString().equalsIgnoreCase(signature);
    }

    public List<? extends CharSequence> getDefinition() {
        if (!this.data.get(0).toString().startsWith("@startdef")) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableList(this.data.subList(1, this.data.size() - 1));
    }

    public Defines getLocalDefines() {
        return this.localDefines;
    }
}

