/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.random;

import java.io.Serializable;
import org.spaceroots.mantissa.random.NormalizedRandomGenerator;
import org.spaceroots.mantissa.random.RandomVectorGenerator;

public class UncorrelatedRandomVectorGenerator
implements Serializable,
RandomVectorGenerator {
    private double[] mean;
    private double[] standardDeviation;
    NormalizedRandomGenerator generator;
    private static final long serialVersionUID = -9094322067568302961L;

    public UncorrelatedRandomVectorGenerator(double[] mean, double[] standardDeviation, NormalizedRandomGenerator generator) {
        if (mean.length != standardDeviation.length) {
            throw new IllegalArgumentException("dimension mismatch");
        }
        this.mean = (double[])mean.clone();
        this.standardDeviation = (double[])standardDeviation.clone();
        this.generator = generator;
    }

    public UncorrelatedRandomVectorGenerator(int dimension, NormalizedRandomGenerator generator) {
        this.mean = new double[dimension];
        this.standardDeviation = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.mean[i] = 0.0;
            this.standardDeviation[i] = 1.0;
        }
        this.generator = generator;
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public double[] nextVector() {
        double[] random = new double[this.mean.length];
        for (int i = 0; i < random.length; ++i) {
            random[i] = this.mean[i] + this.standardDeviation[i] * this.generator.nextDouble();
        }
        return random;
    }
}

