/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.quadrature.scalar;

import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.scalar.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.scalar.ScalarValuedPair;

public class RiemannIntegratorSampler
implements SampledFunctionIterator {
    private SampledFunctionIterator iter;
    private ScalarValuedPair current;
    private double sum;

    public RiemannIntegratorSampler(SampledFunctionIterator iter) throws ExhaustedSampleException, FunctionException {
        this.iter = iter;
        this.current = iter.nextSamplePoint();
        this.sum = 0.0;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public ScalarValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        ScalarValuedPair previous = this.current;
        this.current = this.iter.nextSamplePoint();
        this.sum += (this.current.getX() - previous.getX()) * previous.getY();
        return new ScalarValuedPair(this.current.getX(), this.sum);
    }
}

