/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.RungeKuttaStepInterpolator;

class ThreeEighthesStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = -3345024435978721931L;

    public ThreeEighthesStepInterpolator() {
    }

    public ThreeEighthesStepInterpolator(ThreeEighthesStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    public Object clone() {
        return new ThreeEighthesStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        double fourTheta2 = 4.0 * theta * theta;
        double s = oneMinusThetaH / 8.0;
        double coeff1 = s * (1.0 - 7.0 * theta + 2.0 * fourTheta2);
        double coeff2 = 3.0 * s * (1.0 + theta - fourTheta2);
        double coeff3 = 3.0 * s * (1.0 + theta);
        double coeff4 = s * (1.0 + theta + fourTheta2);
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] - coeff1 * this.yDotK[0][i] - coeff2 * this.yDotK[1][i] - coeff3 * this.yDotK[2][i] - coeff4 * this.yDotK[3][i];
        }
    }
}

