/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoVertexT6OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaVertex;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT6
extends JaVertex {
    private static final long serialVersionUID = 1L;

    @Override
    public final JaObject copy() {
        JaVertexT6 temp = (JaVertexT6)this.copy(new JaVertexT6());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertexT6) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(0.0f));
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        Rectangle2D.Float square = new Rectangle2D.Float();
        square.setFrame(-length, -length, 2.0 * length, 2.0 * length);
        gp.append(square, false);
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(45.0), 0.0, 0.0);
        gp.transform(at);
        gp = this.transv(gp, 1.0);
        g2.fill((Shape)gp);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        float radius = this.getLaTexRadius(scale) * (float)Math.sqrt(2.0);
        String command = "";
        if ((int)radius == 0) {
            command = "%";
        } else {
            Point2D.Float p1 = new Point2D.Float((float)(center.getX() - (double)radius), (float)center.getY());
            Point2D.Float p2 = new Point2D.Float((float)center.getX(), (float)(center.getY() + (double)radius));
            Point2D.Float p3 = new Point2D.Float((float)(center.getX() + (double)radius), (float)center.getY());
            Point2D.Float p4 = new Point2D.Float((float)center.getX(), (float)(center.getY() - (double)radius));
            String tlc = JaxoColor.getColorName(this.getColor());
            command = "\\CTri(" + D_FORMAT.format(((Point2D)p1).getX()) + "," + D_FORMAT.format(((Point2D)p1).getY()) + ")(" + D_FORMAT.format(((Point2D)p2).getX()) + "," + D_FORMAT.format(((Point2D)p2).getY()) + ")(" + D_FORMAT.format(((Point2D)p3).getX()) + "," + D_FORMAT.format(((Point2D)p3).getY()) + "){" + tlc + "}{" + tlc + "}\\CTri(" + D_FORMAT.format(((Point2D)p1).getX()) + "," + D_FORMAT.format(((Point2D)p1).getY()) + ")(" + D_FORMAT.format(((Point2D)p4).getX()) + "," + D_FORMAT.format(((Point2D)p4).getY()) + ")(" + D_FORMAT.format(((Point2D)p3).getX()) + "," + D_FORMAT.format(((Point2D)p3).getY()) + "){" + tlc + "}{" + tlc + "}";
        }
        return command;
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT6OptionsPanel vert6op = new JaxoVertexT6OptionsPanel(this);
        return vert6op.hasChanged();
    }
}

