/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoVertexT2OptionsPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaVertex;
import org.freehep.graphics2d.VectorGraphics;

public class JaVertexT2
extends JaVertex {
    private static final long serialVersionUID = 1L;
    private int rotAngle;
    private Color fillcolor;

    public JaVertexT2() {
        this.setRotAngle(0);
    }

    public final int getRotAngle() {
        return this.rotAngle;
    }

    public final void setRotAngle(int angle) {
        this.rotAngle = angle;
    }

    public final Color getFillColor() {
        return this.fillcolor;
    }

    public final void setFillColor(Color color) {
        this.fillcolor = color;
    }

    @Override
    public final JaObject copy() {
        JaVertexT2 temp = (JaVertexT2)this.copy(new JaVertexT2());
        temp.setFillColor(this.getFillColor());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaVertexT2 && super.isCopy(comp) && ((JaVertexT2)comp).getFillColor().equals(this.getFillColor())) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double length = Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        Ellipse2D.Float blob = new Ellipse2D.Float();
        ((RectangularShape)blob).setFrame(-length, -length, 2.0 * length, 2.0 * length);
        g2.setColor(this.getFillColor());
        g2.setStroke((Stroke)new BasicStroke(0.0f));
        gp.append(blob, false);
        gp = this.trans(gp, 1.0);
        g2.fill((Shape)gp);
        g2.draw((Shape)gp);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
        gp.reset();
        gp.append(blob, false);
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        gp = this.trans(gp, 1.0);
        g2.draw((Shape)gp);
        gp.reset();
        gp.moveTo(0.0f, -((float)length));
        gp.lineTo(0.0f, (float)length);
        gp.moveTo(-((float)length), 0.0f);
        gp.lineTo((float)length, 0.0f);
        gp = this.trans(gp, 0.7f);
        g2.draw((Shape)gp);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D center = this.getLaTexCenter(scale, canvasHeight);
        Point2D axes = this.getLaTexAxes(scale);
        float radius = this.getLaTexRadius(scale);
        String command = "";
        float angle = (float)Math.toDegrees(Math.atan2(this.getRelh(), this.getRelw()));
        if ((int)radius == 0) {
            command = "%";
        } else {
            String command1 = "";
            String tlc = JaxoColor.getColorName(this.getColor());
            if (JaxoColor.isGrayScale(this.getFillColor())) {
                String grayScale = JaxoColor.getGreyScale(this.getFillColor());
                command1 = "\\GOval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")(" + angle + "){" + grayScale + "}";
            } else {
                String tfc = JaxoColor.getColorName(this.getFillColor());
                command1 = "\\COval(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")(" + D_FORMAT.format(axes.getY()) + "," + D_FORMAT.format(axes.getX()) + ")(" + angle + "){" + tlc + "}{" + tfc + "}";
            }
            Point2D.Float invec1 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.5f)), (float)(center.getY() - (double)(radius * 0.5f)));
            Point2D.Float finvec1 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.5f)), (float)(center.getY() + (double)(radius * 0.5f)));
            Point2D.Float invec2 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.5f)), (float)(center.getY() + (double)(radius * 0.5f)));
            Point2D.Float finvec2 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.5f)), (float)(center.getY() - (double)(radius * 0.5f)));
            double theta = 0.7853981633974483 - Math.atan2(this.getRelh(), this.getRelw());
            AffineTransform at = new AffineTransform();
            at.rotate(theta, center.getX(), center.getY());
            Point2D invect1 = new Point2D.Float();
            Point2D finvect1 = new Point2D.Float();
            Point2D invect2 = new Point2D.Float();
            Point2D finvect2 = new Point2D.Float();
            invect1 = at.transform(invec1, invect1);
            finvect1 = at.transform(finvec1, finvect1);
            invect2 = at.transform(invec2, invect2);
            finvect2 = at.transform(finvec2, finvect2);
            String command2 = "\\Line(" + D_FORMAT.format(invect1.getX()) + "," + D_FORMAT.format(invect1.getY()) + ")(" + D_FORMAT.format(finvect1.getX()) + "," + D_FORMAT.format(finvect1.getY()) + ")";
            String command3 = "\\Line(" + D_FORMAT.format(invect2.getX()) + "," + D_FORMAT.format(invect2.getY()) + ")(" + D_FORMAT.format(finvect2.getX()) + "," + D_FORMAT.format(finvect2.getY()) + ")";
            command = command1 + command2 + command3;
        }
        return command;
    }

    private Point2D getLaTexAxes(float scaleFactor) {
        Point2D.Float axesVec = new Point2D.Float();
        float length = (float)Math.sqrt((double)this.getWidth() * (double)this.getWidth() + (double)this.getHeight() * (double)this.getHeight());
        float wdt = length / scaleFactor;
        ((Point2D)axesVec).setLocation(wdt, wdt);
        return axesVec;
    }

    @Override
    public final boolean editPanel() {
        JaxoVertexT2OptionsPanel vert2op = new JaxoVertexT2OptionsPanel(this);
        return vert2op.hasChanged();
    }
}

