/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import graph.RTextLine;
import japlot.JaTextOptionsPanel;
import japlot.jaxodraw.JaxoColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaObject;
import jplot.Translate;
import org.freehep.graphics2d.VectorGraphics;

public class JaTextBox
extends JaFillObject {
    private String textString;
    private RTextLine rtext;
    private String stext;
    private String[] multitext;
    private Font textFont;
    private int rotAngle;
    private boolean isMultiline;
    private static boolean first = true;
    private static double sH;
    private static double sW;
    private static double sD;
    private float[] ypos;
    private float[] xpos;
    private Color shadowColor;
    private int shadowXOffset;
    private int shadowYOffset;
    private boolean isShadow;
    private int type;
    private int padX;
    private int padY;
    private static final long serialVersionUID = 1L;

    public JaTextBox() {
        this.setColor(Color.black);
        this.setFillColor(new Color(235, 255, 255));
        this.setRelw(100);
        this.setRelh(30);
        this.textString = null;
        this.multitext = null;
        this.isMultiline = false;
        this.xpos = null;
        this.ypos = null;
        this.textFont = new Font("Dialog", 1, 16);
        this.rtext = new RTextLine();
        this.shadowColor = Color.gray;
        this.shadowXOffset = 5;
        this.shadowYOffset = 5;
        this.isShadow = true;
        this.type = 0;
        this.padX = 0;
        this.padY = 0;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setPadX(int pad) {
        this.padX = pad;
    }

    public int getPadX() {
        return this.padX;
    }

    public void setPadY(int pad) {
        this.padY = pad;
    }

    public int getPadY() {
        return this.padY;
    }

    public boolean isShadow() {
        return this.isShadow;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public void setMultiText(String[] multitext) {
        this.multitext = multitext;
        this.isMultiline = true;
        this.textString = null;
        this.ypos = new float[multitext.length];
        this.xpos = new float[multitext.length];
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public int getShadowXOffset() {
        return this.shadowXOffset;
    }

    public int getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowXOffset(int shadowXOffset) {
        this.shadowXOffset = shadowXOffset;
    }

    public void setShadowYOffset(int shadowYOffset) {
        this.shadowYOffset = shadowYOffset;
    }

    public String[] getMultiText() {
        return this.multitext;
    }

    public final Font getFont() {
        return this.textFont;
    }

    public final void setFont(Font font) {
        this.textFont = font;
        this.rtext.setFont(this.textFont);
    }

    public final void setShadow(boolean shadow) {
        this.isShadow = shadow;
    }

    public final void setShadowSize(int size) {
        this.shadowXOffset = size;
        this.shadowYOffset = size;
    }

    public final int getRotAngle() {
        return this.rotAngle;
    }

    public final void setRotAngle(int angle) {
        this.rotAngle = angle;
    }

    public final String getText() {
        return this.textString;
    }

    private final void parseText() {
        if (this.textString == null) {
            return;
        }
        this.rtext.setFont(this.getFont());
        this.rtext.setColor(this.getColor());
        this.rtext.setText(Translate.decode(this.textString));
        this.stext = Translate.shrink(this.textString);
        first = true;
    }

    public final void setText(String string) {
        this.multitext = null;
        this.textString = string;
        this.isMultiline = false;
        this.parseText();
    }

    @Override
    public final JaObject copy() {
        JaTextBox temp = new JaTextBox();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setType(this.type);
        temp.setPadX(this.padX);
        temp.setPadY(this.padY);
        temp.setShadow(this.isShadow);
        temp.setShadowXOffset(this.shadowXOffset);
        temp.setShadowYOffset(this.shadowYOffset);
        if (this.isMultiline) {
            temp.setMultiText(this.multitext);
        }
        temp.setColor(this.getColor());
        temp.setFillColor(this.getFillColor());
        temp.setStroke(this.getStroke());
        temp.setRotAngle(this.getRotAngle());
        if (!this.isMultiline) {
            temp.setText(this.textString);
        }
        temp.setFont(this.getFont());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaTextBox temp;
        boolean isCopy = false;
        if (comp instanceof JaTextBox && (temp = (JaTextBox)comp).getX() == this.getX() && temp.getY() == this.getY() && temp.getColor().equals(this.getColor()) && temp.getFillColor().equals(this.getFillColor()) && temp.getText().equals(this.getText()) && temp.getFont().equals(this.getFont()) && temp.getStroke() == this.getStroke() && temp.getType() == this.getType() && temp.getRelw() == this.getRelw() && temp.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        if (editmode == 50 || editmode == 52) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            return 0;
        }
        if (editmode == 51) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 14;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 15;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 13;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 12;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.drawRect(x - 8, y - 8, 8, 8);
        g2.drawRect(x - 8, y + height, 8, 8);
        g2.drawRect(x + width, y - 8, 8, 8);
        g2.drawRect(x + width, y + height, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(x - 8 + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x - 8 + 1, y + height + 1, 7, 7);
            g2.fillRect(x + width + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x + width + 1, y + height + 1, 7, 7);
        }
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        FontMetrics fm;
        if (this.multitext == null && this.textString == null) {
            return;
        }
        if (this.multitext != null && this.multitext[0].equals("UNDEFINED")) {
            return;
        }
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        double wid = 0.0;
        if (first && !this.isMultiline) {
            fm = g2.getFontMetrics(this.getFont());
            sH = 1.2 * (double)fm.getHeight();
            wid = fm.stringWidth(this.stext);
            sW = 1.2 * wid;
            sD = 0.1 * wid;
            this.setRelw((int)sW);
            this.setRelh((int)sH);
            first = false;
        }
        if (this.isMultiline) {
            fm = g2.getFontMetrics(this.getFont());
            sH = 1.1 * (double)fm.getHeight();
            wid = fm.stringWidth(this.multitext[0]);
            sW = 1.1 * wid;
            sD = 0.1 * wid;
            double HH = 0.0;
            double xmax = 0.0;
            for (int i = 0; i < this.multitext.length; ++i) {
                wid = fm.stringWidth(this.multitext[i]);
                if (wid > xmax) {
                    xmax = wid;
                }
                this.xpos[i] = (float)((double)this.getX() + sD);
                this.ypos[i] = (float)((double)this.getY() + sH + HH);
                HH += sH;
            }
            sW = 1.2 * xmax;
            this.setRelw((int)sW);
            this.setRelh((int)(HH + 0.25 * sH));
        }
        if (this.isShadow) {
            Rectangle2D.Float shadow = new Rectangle2D.Float();
            shadow.setFrame(this.getX() + this.shadowXOffset, this.getY() + this.shadowYOffset, this.getWidth(), this.getHeight());
            g2.setColor(this.shadowColor);
            g2.fill((Shape)shadow);
        }
        Rectangle2D.Float box = new Rectangle2D.Float();
        box.setFrame(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        gp.append(box, false);
        g2.setColor(this.getFillColor());
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.fill((Shape)gp);
        gp.reset();
        gp.append(box, false);
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        g2.draw((Shape)gp);
        if (this.isMultiline) {
            for (int i = 0; i < this.multitext.length; ++i) {
                RTextLine dtex = new RTextLine();
                dtex.setColor(this.getColor());
                dtex.setFont(this.getFont());
                dtex.setText(Translate.decode(this.multitext[i]));
                dtex.draw(g2, (int)this.xpos[i], (int)this.ypos[i]);
            }
        } else {
            float x = (float)((double)this.getX() + sD);
            float y = (float)((double)this.getY() + 0.75 * (double)this.getHeight());
            this.rtext.draw(g2, (int)x, (int)y);
        }
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX() + 0.5 * (double)this.shadowXOffset, bb.getMaxY() + 0.5 * (double)this.shadowYOffset};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D lowerCorner = this.getLaTexLowerCorner(scale, canvasHeight);
        Point2D upperCorner = this.getLaTexUpperCorner(scale, canvasHeight);
        String command = "";
        if ((int)lowerCorner.getX() == (int)upperCorner.getX() && (int)lowerCorner.getY() == (int)upperCorner.getY()) {
            command = "%";
        } else if (JaxoColor.isGrayScale(this.getFillColor())) {
            String grayScale = JaxoColor.getGreyScale(this.getFillColor());
            command = "\\GBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + grayScale + "}";
        } else {
            String tlc = JaxoColor.getColorName(this.getColor());
            String tfc = JaxoColor.getColorName(this.getFillColor());
            command = "\\CBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + tlc + "}{" + tfc + "}";
        }
        return command;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    private Point2D getLaTexLowerCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float lowerCornerVec = new Point2D.Float();
        float x1 = this.getX();
        float y1 = this.getY() + this.getHeight();
        ((Point2D)lowerCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return lowerCornerVec;
    }

    private Point2D getLaTexUpperCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float upperCornerVec = new Point2D.Float();
        float x1 = this.getX() + this.getWidth();
        float y1 = this.getY();
        ((Point2D)upperCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return upperCornerVec;
    }

    @Override
    public final boolean editPanel() {
        JaTextOptionsPanel boxop = new JaTextOptionsPanel(this);
        return boxop.hasChanged();
    }
}

