/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import graph.RTextLine;
import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoPSTextOptionsPanel;
import japlot.jaxodraw.JaxoStaticCanvasMethods;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jhplot.jadraw.JaObject;
import jplot.Translate;
import org.freehep.graphics2d.VectorGraphics;

public class JaText
extends JaObject {
    private static final long serialVersionUID = 1L;
    private String textString;
    private RTextLine rtext;
    private String stext;
    private int type;
    private int padX;
    private int padY;
    private Font textFont;
    private int rotAngle;
    private String[] availableFonts;

    public JaText() {
        this.setRelw(2);
        this.setRelh(2);
        this.setColor(Color.black);
        this.type = 0;
        this.padX = 0;
        this.padY = 0;
        this.textFont = new Font("Dialog", 1, 16);
        this.rtext = new RTextLine();
    }

    public JaText(String text, double x1, double y1, String what) {
        this.setColor(Color.black);
        this.setRelw(2);
        this.setRelh(2);
        this.type = 0;
        this.padX = 0;
        this.padY = 0;
        this.textFont = new Font("Dialog", 1, 16);
        this.rtext = new RTextLine();
        this.setLocation(x1, y1, what);
        this.textString = text;
        this.parseText();
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setPadX(int pad) {
        this.padX = pad;
    }

    public int getPadX() {
        return this.padX;
    }

    public void setPadY(int pad) {
        this.padY = pad;
    }

    public int getPadY() {
        return this.padY;
    }

    public final Font getFont() {
        return this.textFont;
    }

    public final void setFont(Font font) {
        this.textFont = font;
        this.rtext.setFont(this.textFont);
    }

    public final int getRotAngle() {
        return this.rotAngle;
    }

    public final void setRotAngle(int angle) {
        this.rotAngle = angle;
    }

    public final String getText() {
        return this.textString;
    }

    private final void parseText() {
        this.rtext.setFont(this.getFont());
        this.rtext.setColor(this.getColor());
        this.rtext.setText(Translate.decode(this.textString));
        this.stext = Translate.shrink(this.textString);
    }

    public final void setText(String string) {
        this.textString = string;
        this.parseText();
    }

    @Override
    public final JaObject copy() {
        JaText temp = new JaText();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setPadX(this.padX);
        temp.setPadY(this.padY);
        temp.setRotAngle(this.getRotAngle());
        temp.setColor(this.getColor());
        temp.setText(this.textString);
        temp.setFont(this.getFont());
        temp.setBoundingBox(this.getBoundingBox());
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaText text;
        boolean isCopy = false;
        if (comp instanceof JaText && (text = (JaText)comp).getX() == this.getX() && text.getY() == this.getY() && text.getRotAngle() == this.getRotAngle() && text.getColor().equals(this.getColor()) && text.getType() == this.getType() && text.getText().equals(this.getText()) && text.getFont().equals(this.getFont())) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int length = 8;
        if (editmode == 50 || editmode == 52) {
            if (clickX >= this.getX() - length / 2 && clickX <= this.getX() + length / 2 && clickY >= this.getY() - length / 2 && clickY <= this.getY() + length / 2) {
                return 11;
            }
            return 0;
        }
        if (editmode == 51) {
            return 0;
        }
        return 0;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        if (this.textString.equals("")) {
            return;
        }
        Font baseFont = this.getFont();
        this.rtext.setColor(this.getColor());
        this.rtext.setFont(this.getFont());
        float x = this.getX();
        float y = this.getY();
        double theta = Math.toRadians(this.rotAngle);
        g2.rotate(theta, (double)x, (double)y);
        this.rtext.setRotation(this.rotAngle);
        this.rtext.draw(g2, (int)x, (int)y);
        g2.rotate(-theta, (double)x, (double)y);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout layout = new TextLayout(this.textString, baseFont, frc);
        Rectangle2D bb = layout.getBounds();
        GeneralPath gp = new GeneralPath(bb);
        AffineTransform at = AffineTransform.getRotateInstance(theta);
        gp.transform(at);
        bb = gp.getBounds();
        double[] bbox = new double[]{bb.getMinX() + (double)this.getX(), bb.getMinY() + (double)this.getY(), bb.getMaxX() + (double)this.getX(), bb.getMaxY() + (double)this.getY() + 5.0};
        this.setBoundingBox(bbox);
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        int length = 8;
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.drawRect(this.getX() - length / 2, this.getY() - length / 2, length, length);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(this.getX() - length / 2 + 1, this.getY() - length / 2 + 1, length - 1, length - 1);
        }
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        String command = "% There is a postscript text here!";
        return command;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
    }

    @Override
    public final String latexWidth() {
        String lineWidth = "%";
        return lineWidth;
    }

    @Override
    public final boolean editPanel() {
        if (this.availableFonts == null) {
            this.availableFonts = JaxoStaticCanvasMethods.getSystemFonts();
        }
        JaxoPSTextOptionsPanel textop = new JaxoPSTextOptionsPanel(this, this.availableFonts);
        return textop.hasChanged();
    }

    public final void setAvailableFonts(String[] fonts) {
        this.availableFonts = fonts;
    }

    public final void print() {
        System.out.println("JaText object");
        System.out.println("     -      text: " + this.getText());
        System.out.println("     -     (x,y): " + Integer.toString(this.getX()) + "," + Integer.toString(this.getY()));
        System.out.println("     - NDC (x,y): " + Double.toString(this.getXndc()) + "," + Double.toString(this.getYndc()));
    }
}

