/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoLineOptionsPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jhplot.jadraw.JaGlLine;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public abstract class JaLineObject
extends JaObject {
    protected float stroke;
    private float dash;
    private float freq;
    private boolean arrow;
    private boolean end;
    private boolean flip;
    private boolean inflip;
    private boolean symm;
    private boolean back;
    private int amp;
    private boolean doubleLine;
    private float dlSeparation;

    public JaLineObject() {
        this.setRelw(25);
        this.setRelh(25);
        this.setAmp(JaxoPrefs.getIntPref(104));
        this.setFreq(20.0f);
        this.setColor(JaxoColor.getColor(JaxoPrefs.getPref(6)));
        this.setStroke(JaxoPrefs.getFloatPref(200));
        this.setSymm(false);
        this.setDoubleLine(false);
        this.setDLSeparation(JaxoPrefs.getFloatPref(201));
    }

    public final float getStroke() {
        return this.stroke;
    }

    public final void setStroke(float newStroke) {
        this.stroke = newStroke;
    }

    public final float getDash() {
        return this.dash;
    }

    public final void setDash(float newDash) {
        this.dash = newDash;
    }

    public final float getFreq() {
        return this.freq;
    }

    public final void setFreq(float newFreq) {
        this.freq = newFreq;
    }

    public final boolean isArrow() {
        return this.arrow;
    }

    public final boolean getArrow() {
        return this.arrow;
    }

    public final void setArrow(boolean arr) {
        this.arrow = arr;
    }

    public final boolean isEnd() {
        return this.end;
    }

    public final boolean getEnd() {
        return this.end;
    }

    public final void setEnd(boolean mid) {
        this.end = mid;
    }

    public final boolean isFlip() {
        return this.flip;
    }

    public final boolean getFlip() {
        return this.flip;
    }

    public final void setFlip(boolean newFlip) {
        this.flip = newFlip;
    }

    public final boolean isBack() {
        return this.back;
    }

    public final boolean getBack() {
        return this.back;
    }

    public final void setBack(boolean newBack) {
        this.back = newBack;
    }

    public final boolean isInflip() {
        return this.inflip;
    }

    public final boolean getInflip() {
        return this.inflip;
    }

    public final void setInflip(boolean newInflip) {
        this.inflip = newInflip;
    }

    public final boolean isSymm() {
        return this.symm;
    }

    public final boolean getSymm() {
        return this.symm;
    }

    public final void setSymm(boolean newSymm) {
        this.symm = newSymm;
    }

    public final int getAmp() {
        return this.amp;
    }

    public final void setAmp(int newAmp) {
        this.amp = newAmp;
    }

    public final void setDoubleLine(boolean dline) {
        this.doubleLine = dline;
    }

    public final boolean getDoubleLine() {
        return this.doubleLine;
    }

    public final void setDLSeparation(float dlsep) {
        this.dlSeparation = dlsep;
    }

    public final float getDLSeparation() {
        return this.dlSeparation;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int l2 = 4;
        if (editmode == 50 || editmode == 52) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
                if (clickX >= x + w / 2 - l2 && clickX <= x + w / 2 + l2 && clickY >= y + h / 2 - l2 && clickY <= y + h / 2 + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
            } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
                if (clickX >= x + w / 2 - l2 && clickX <= x + w / 2 + l2 && clickY >= y + h / 2 - l2 && clickY <= y + h / 2 + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
            } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
                if (clickX >= x + w / 2 - l2 && clickX <= x + w / 2 + l2 && clickY >= y + h / 2 - l2 && clickY <= y + h / 2 + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
            } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 11;
                }
                if (clickX >= x + w / 2 - l2 && clickX <= x + w / 2 + l2 && clickY >= y + h / 2 - l2 && clickY <= y + h / 2 + l2) {
                    return 11;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 11;
                }
            }
            return 0;
        }
        if (editmode == 51) {
            if (this.getRelw() > 0 && this.getRelh() >= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    this.setBack(true);
                    this.setInflip(!this.getInflip());
                    this.setRelWAndH(-this.getRelw(), -this.getRelh());
                    return 12;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 14;
                }
            } else if (this.getRelw() < 0 && this.getRelh() <= 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 12;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    this.setBack(true);
                    this.setInflip(!this.getInflip());
                    this.setRelWAndH(-this.getRelw(), -this.getRelh());
                    return 14;
                }
            } else if (this.getRelw() >= 0 && this.getRelh() < 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    this.setBack(true);
                    this.setInflip(!this.getInflip());
                    this.setRelWAndH(-this.getRelw(), -this.getRelh());
                    return 15;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    return 13;
                }
            } else if (this.getRelw() <= 0 && this.getRelh() > 0) {
                if (clickX >= x - l2 && clickX <= x + l2 && clickY >= y + h - l2 && clickY <= y + h + l2) {
                    return 15;
                }
                if (clickX >= x + w - l2 && clickX <= x + w + l2 && clickY >= y - l2 && clickY <= y + l2) {
                    this.setBack(true);
                    this.setInflip(!this.getInflip());
                    this.setRelWAndH(-this.getRelw(), -this.getRelh());
                    return 13;
                }
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        int l2 = 4;
        if (this.getRelw() >= 0 && this.getRelh() >= 0 || this.getRelw() <= 0 && this.getRelh() <= 0) {
            g2.setColor(JaxoColor.RED);
            g2.setStroke((Stroke)new BasicStroke(1.2f));
            g2.drawRect(x - l2, y - l2, 8, 8);
            g2.drawRect(x + (w - 8) / 2, y + (h - 8) / 2, 8, 8);
            g2.drawRect(x + w - l2, y + h - l2, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(x - l2 + 1, y - l2 + 1, 7, 7);
                g2.fillRect(x + (w - 8) / 2 + 1, y + (h - 8) / 2 + 1, 7, 7);
                g2.fillRect(x + w - l2 + 1, y + h - l2 + 1, 7, 7);
            }
        } else if (this.getRelw() < 0 && this.getRelh() > 0 || this.getRelw() > 0 && this.getRelh() < 0) {
            g2.setColor(JaxoColor.RED);
            g2.setStroke((Stroke)new BasicStroke(1.2f));
            g2.drawRect(x - l2, y + h - l2, 8, 8);
            g2.drawRect(x + (w - 8) / 2, y + (h - 8) / 2, 8, 8);
            g2.drawRect(x + w - l2, y - l2, 8, 8);
            if (this.isMarked()) {
                g2.setColor(JaxoColor.GRAYSCALE150);
                g2.fillRect(x - l2 + 1, y + h - l2 + 1, 7, 7);
                g2.fillRect(x + (w - 8) / 2 + 1, y + (h - 8) / 2 + 1, 7, 7);
                g2.fillRect(x + w - l2 + 1, y - l2 + 1, 7, 7);
            }
        }
    }

    protected final GeneralPath lineArrow(VectorGraphics g2, Color c, double length, float size, boolean fl) {
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, 0.0f);
        gp.lineTo(-arrowsize, arrowsize / 1.5f);
        gp.lineTo(-arrowsize / 1.5f, 0.0f);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        if (this.isEnd()) {
            at.translate(length, 0.0);
        } else {
            at.translate(length / 2.0, 0.0);
        }
        if (fl) {
            if (this.isEnd()) {
                at.translate(-length, 0.0);
            }
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        gp = this.trans(gp, 1.0);
        g2.setPaint((Paint)c);
        g2.fill((Shape)gp);
        return gp;
    }

    protected final GeneralPath dLineArrow(VectorGraphics g2, Color c, double length, float size, boolean fl, float dlSep) {
        g2.setStroke((Stroke)new BasicStroke(2.0f));
        GeneralPath gp = new GeneralPath();
        float arrowsize = 5.0f * size / 8.0f;
        gp.moveTo(arrowsize, dlSep);
        gp.lineTo(-arrowsize, arrowsize / 1.5f + dlSep);
        gp.lineTo(-arrowsize / 1.5f, dlSep);
        gp.lineTo(-arrowsize, -arrowsize / 1.5f + dlSep);
        gp.closePath();
        AffineTransform at = new AffineTransform();
        if (this.isEnd()) {
            at.translate(length, 0.0);
        } else {
            at.translate(length / 2.0, 0.0);
        }
        if (fl) {
            if (this.isEnd()) {
                at.translate(-length, 0.0);
            }
            at.rotate(Math.toRadians(180.0), 0.0, 0.0);
        }
        gp.transform(at);
        gp = this.trans(gp, 1.0);
        g2.setPaint((Paint)c);
        g2.fill((Shape)gp);
        return gp;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int oldWidth = this.getSize().width;
        int oldHeight = this.getSize().height;
        int newWidth = Math.round((float)oldWidth * scale);
        int newHeight = Math.round((float)oldHeight * scale);
        int newRelWidth = Math.round((float)this.getRelSize().width * scale);
        int newRelHeight = Math.round((float)this.getRelSize().height * scale);
        int newAmp = (int)((float)this.getAmp() * scale);
        int wiggleNumbers = 0;
        wiggleNumbers = this instanceof JaGlLine ? (int)Math.round((Math.sqrt(oldWidth * oldWidth + oldHeight * oldHeight) - (double)this.getFreq()) / (double)this.getFreq() / (double)0.6f) : (int)Math.round(Math.sqrt(oldWidth * oldWidth + oldHeight * oldHeight) / (double)this.getFreq());
        float newFreq = 0.0f;
        newFreq = this instanceof JaGlLine ? (float)(Math.sqrt(newWidth * newWidth + newHeight * newHeight) / (double)((float)wiggleNumbers * 0.6f + 1.0f)) : (float)(Math.sqrt(newWidth * newWidth + newHeight * newHeight) / (double)wiggleNumbers);
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
        this.setFreq(newFreq);
        this.setAmp(newAmp);
    }

    public final void baseEditPanel(JaxoLineOptionsPanel lineop) {
        lineop.addFinalDimSPanel(0, 0);
        lineop.addFinalStrSPanel(0, 1);
        lineop.addColorPanel(1, 1);
    }

    @Override
    public final String latexWidth() {
        String thisValue = Float.toString(this.getStroke() / 2.0f);
        String base = "\\SetWidth{";
        String closing = "}";
        String lineWidth = base.concat(thisValue.concat(closing));
        return lineWidth;
    }
}

