/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.jaxodraw.JaxoColor;
import japlot.jaxodraw.JaxoLatexTextOptionsPanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jhplot.jadraw.JaObject;
import org.freehep.graphics2d.VectorGraphics;

public class JaLatexText
extends JaObject {
    private static final long serialVersionUID = 1L;
    private String textString;
    private int allign;
    private int latexfs;
    private JPanel latexPanel = new JPanel();
    private JLabel latexLabel;
    private int rotAngle;

    public JaLatexText() {
        this.setRelw(2);
        this.setRelh(2);
    }

    public final void createLatexPanel() {
        this.latexLabel = new JLabel(" " + this.textString + " ");
        this.latexPanel.setLayout(new BorderLayout());
        this.latexPanel.add((Component)this.latexLabel, "Center");
        this.latexPanel.setBackground(new Color(250, 250, 200));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.latexPanel.setBorder(blackline);
    }

    public final JPanel getLatexPanel() {
        return this.latexPanel;
    }

    public final void setLatexLabel(String str) {
        if (str != null) {
            this.latexLabel.setText(str);
        }
    }

    public final String getTextString() {
        return this.textString;
    }

    public final void setTextString(String string) {
        this.textString = string;
    }

    public final int getAllign() {
        return this.allign;
    }

    public final void setAllign(int newAllign) {
        this.allign = newAllign;
    }

    public final int getLatexFS() {
        return this.latexfs;
    }

    public final void setLatexFS(int newLatexfs) {
        this.latexfs = newLatexfs;
    }

    public final int getRotAngle() {
        return this.rotAngle;
    }

    public final void setRotAngle(int angle) {
        this.rotAngle = angle;
    }

    @Override
    public final JaObject copy() {
        JaLatexText temp = new JaLatexText();
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setRotAngle(this.getRotAngle());
        temp.setColor(this.getColor());
        temp.setTextString(this.textString);
        temp.setAllign(this.allign);
        temp.setLatexFS(this.latexfs);
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaLatexText tmp;
        boolean isCopy = false;
        if (comp instanceof JaLatexText && (tmp = (JaLatexText)comp).getX() == this.getX() && tmp.getY() == this.getY() && tmp.getRotAngle() == this.getRotAngle() && tmp.getColor().equals(this.getColor()) && tmp.getTextString().equals(this.getTextString()) && tmp.getAllign() == this.getAllign() && tmp.getLatexFS() == this.getLatexFS()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        int length = 8;
        if (editmode == 50 || editmode == 52) {
            if (clickX >= this.getX() - length / 2 && clickX <= this.getX() + length / 2 && clickY >= this.getY() - length / 2 && clickY <= this.getY() + length / 2) {
                return 11;
            }
            return 0;
        }
        if (editmode == 51) {
            return 0;
        }
        return 0;
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        if (drawToScreen) {
            this.drawTexVisualAid(g2);
        }
    }

    public final void drawTexVisualAid(VectorGraphics g2) {
        int x = this.getX();
        int y = this.getY();
        double theta = Math.toRadians(this.rotAngle);
        char[] ltT = new char[]{'T'};
        char[] ltE = new char[]{'E'};
        char[] ltX = new char[]{'X'};
        Font ltTFont = new Font("Utopia", 0, 18);
        Font ltEFont = new Font("Utopia", 0, 14);
        Font ltXFont = ltTFont;
        g2.rotate(theta, (double)x, (double)y);
        int xOff = 5;
        int yOff = 16;
        if (this.allign == 3 || this.allign == 4 || this.allign == 5) {
            xOff = -13;
        } else if (this.allign == 6 || this.allign == 7 || this.allign == 8) {
            xOff = -31;
        }
        if (this.allign == 1 || this.allign == 4 || this.allign == 7) {
            yOff = 5;
        } else if (this.allign == 2 || this.allign == 5 || this.allign == 8) {
            yOff = -6;
        }
        g2.setColor(JaxoColor.GRAYSCALE180);
        g2.setFont(ltTFont);
        g2.drawChars(ltT, 0, ltT.length, x + xOff, y + yOff);
        g2.setFont(ltEFont);
        g2.drawChars(ltE, 0, ltE.length, x + xOff + 9, y + yOff + 2);
        g2.setFont(ltXFont);
        g2.drawChars(ltX, 0, ltX.length, x + xOff + 17, y + yOff);
        g2.setColor(JaxoColor.CADET_BLUE);
        g2.setFont(ltTFont);
        g2.drawChars(ltT, 0, ltT.length, x + xOff - 1, y + yOff - 1);
        g2.setFont(ltEFont);
        g2.drawChars(ltE, 0, ltE.length, x + xOff + 8, y + yOff + 1);
        g2.setFont(ltXFont);
        g2.drawChars(ltX, 0, ltX.length, x + xOff + 18, y + yOff - 1);
        g2.rotate(-theta, (double)x, (double)y);
        this.setBoundingBox(this.getBoundingBox());
    }

    public final boolean isRolledOver(int mouseX, int mouseY) {
        double[] bbox = this.getBoundingBox();
        int[] iconbox = new int[]{(int)bbox[0], (int)bbox[1] - 5, (int)bbox[2] + 5, (int)bbox[3] + 2};
        boolean isContained = false;
        if (mouseX > iconbox[0] && mouseX < iconbox[2] && mouseY > iconbox[1] && mouseY < iconbox[3]) {
            isContained = true;
        }
        return isContained;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        int length = 8;
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.drawRect(this.getX() - length / 2, this.getY() - length / 2, length, length);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(this.getX() - length / 2 + 1, this.getY() - length / 2 + 1, length - 1, length - 1);
        }
    }

    @Override
    public final double[] getBoundingBox() {
        double minX = 0.0;
        double maxX = 1.0;
        double minY = 0.0;
        double maxY = 1.0;
        double[] bBox = new double[]{minX, minY, maxX, maxY};
        int x = this.getX();
        int y = this.getY();
        double theta = Math.toRadians(this.rotAngle);
        GeneralPath gp = new GeneralPath();
        AffineTransform at = new AffineTransform();
        at.rotate(theta, x, y);
        if (this.allign == 0) {
            Rectangle2D bb = new Rectangle2D.Double(x, y, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 1) {
            Rectangle2D bb = new Rectangle2D.Double(x, y - 8, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 2) {
            Rectangle2D bb = new Rectangle2D.Double(x, y - 16, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 3) {
            Rectangle2D bb = new Rectangle2D.Double(x - 15, y, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 4) {
            Rectangle2D bb = new Rectangle2D.Double(x - 15, y - 8, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 5) {
            Rectangle2D bb = new Rectangle2D.Double(x - 15, y - 16, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 6) {
            Rectangle2D bb = new Rectangle2D.Double(x - 30, y, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 7) {
            Rectangle2D bb = new Rectangle2D.Double(x - 30, y - 8, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        if (this.allign == 8) {
            Rectangle2D bb = new Rectangle2D.Double(x - 30, y - 16, 30.0, 16.0);
            gp.reset();
            gp.append(bb, false);
            gp.transform(at);
            bb = gp.getBounds();
            double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
            return bbox;
        }
        return bBox;
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        String command;
        int canvasHeight = canvasDim.height;
        Point2D position = this.getLaTexPosition(scale, canvasHeight);
        String allignCode = this.getLaTexAllign(this.allign);
        String fontSize = this.getLaTexFontSize(this.latexfs);
        String color = "\\" + JaxoColor.getColorName(this.getColor());
        String base = "\\Text";
        if (this.getRotAngle() != 0) {
            int ang = -this.getRotAngle();
            command = base + "(" + D_FORMAT.format(position.getX()) + "," + D_FORMAT.format(position.getY()) + ")" + allignCode + fontSize + color + "{$\\rput" + allignCode + "{" + ang + "}{" + this.textString + "}$}}}";
        } else {
            command = base + "(" + D_FORMAT.format(position.getX()) + "," + D_FORMAT.format(position.getY()) + ")" + allignCode + fontSize + color + "{$" + this.textString + "$}}}";
        }
        return command;
    }

    @Override
    public final String latexWidth() {
        String lineWidth = "%";
        return lineWidth;
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)Math.round(newP.getX()));
        this.setY((int)Math.round(newP.getY()));
    }

    private Point2D getLaTexPosition(float scaleFactor, int canvasHeight) {
        Point2D.Float positionPoint = new Point2D.Float();
        ((Point2D)positionPoint).setLocation((float)this.getX() / scaleFactor, (float)(canvasHeight - this.getY()) / scaleFactor);
        return positionPoint;
    }

    private String getLaTexAllign(int all) {
        String[] possible = new String[]{"[lt]", "[l]", "[lb]", "[t]", "[]", "[b]", "[rt]", "[r]", "[rb]"};
        return possible[all];
    }

    private String getLaTexFontSize(int fs) {
        String[] allowed = new String[]{"{\\tiny{", "{\\scriptsize{", "{\\footnotesize{", "{\\small{", "{\\normalsize{", "{\\large{", "{\\Large{", "{\\LARGE{", "{\\huge{", "{\\Huge{"};
        return allowed[fs];
    }

    @Override
    public final boolean editPanel() {
        JaxoLatexTextOptionsPanel latop = new JaxoLatexTextOptionsPanel(this);
        return latop.hasChanged();
    }
}

