/*
 * Decompiled with CFR 0.152.
 */
package jhplot.jadraw;

import japlot.Global;
import japlot.JaAxesOptionsPanel;
import japlot.jaxodraw.JaxoColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import jhplot.H2D;
import jhplot.jadraw.DrawAxesTics;
import jhplot.jadraw.DrawContour;
import jhplot.jadraw.DrawGraph_2D;
import jhplot.jadraw.DrawGrid;
import jhplot.jadraw.JaFillObject;
import jhplot.jadraw.JaObject;
import jplot.Axis;
import jplot.Contour;
import jplot.DataArray;
import jplot.PlotPoint;
import jplot.Utils;
import org.apache.commons.math3.util.FastMath;
import org.freehep.graphics2d.VectorGraphics;

public class JaAxes
extends JaFillObject {
    protected final int NAXES = 2;
    protected final int X = 0;
    protected final int Y = 1;
    protected Vector<DataArray> data;
    private int[] pad;
    private double[] min;
    private double[] max;
    private double[] diff;
    private double[] inv;
    protected String[][] ticLabel;
    protected double[][] ticNumber;
    private int[] numberOfTics;
    private int[] numberOfTicsEstimated;
    protected int[] maxLabelWidth;
    protected int[] maxLabelHight;
    private Color backgroundColor;
    private Color gridColor;
    private boolean[] show;
    private boolean[] showMirror;
    private boolean[] showGrid;
    private Font labelFont;
    private Color labelColor;
    protected double labelRotation;
    protected double[] labelSpace;
    private int expForm;
    private boolean[] logScale;
    private boolean[] rotateTic;
    private boolean[] useTicLabels;
    private static Rectangle2D.Double rect = new Rectangle2D.Double();
    protected int[] AxisExponent;
    protected double[] axisLength;
    protected double leftMargin;
    protected double rightMargin;
    protected double bottomMargin;
    protected double topMargin;
    protected double[] ticLength;
    protected double[] subticLength;
    private int[] subticNumber;
    protected int[] axesArrow;
    protected boolean[] autoRange;
    protected int plotType;
    private String[] statistics;
    protected boolean isContour;
    protected int ContourLevels;
    protected boolean isContourBar;
    protected int ContourBinX;
    protected int ContourBinY;
    protected boolean isContourGray;
    protected Contour contour;
    protected H2D h2d;
    protected boolean isShowKey;
    private boolean isGridFront;
    protected static boolean default_AXES;
    private static final long serialVersionUID = 1L;

    public JaAxes(int padX, int padY) {
        this.setRelw(25);
        this.setRelh(25);
        this.setStroke(2.0f);
        default_AXES = true;
        this.isGridFront = false;
        this.isShowKey = true;
        this.autoRange = new boolean[2];
        this.autoRange[0] = true;
        this.autoRange[1] = true;
        this.data = new Vector();
        this.pad = new int[2];
        this.pad[0] = padX;
        this.pad[1] = padY;
        this.show = new boolean[2];
        this.show[0] = true;
        this.show[1] = true;
        this.showMirror = new boolean[2];
        this.showMirror[0] = true;
        this.showMirror[1] = true;
        this.axesArrow = new int[2];
        this.axesArrow[0] = 0;
        this.axesArrow[1] = 0;
        this.showGrid = new boolean[2];
        this.showGrid[0] = false;
        this.showGrid[1] = false;
        this.min = new double[2];
        this.max = new double[2];
        this.rotateTic = new boolean[2];
        this.rotateTic[0] = false;
        this.rotateTic[1] = false;
        this.min[0] = 0.0;
        this.min[1] = 0.0;
        this.max[0] = 1.0;
        this.max[1] = 1.0;
        this.expForm = 3;
        this.labelColor = Color.black;
        this.labelRotation = 0.0;
        this.labelSpace = new double[2];
        this.labelSpace[0] = 0.01;
        this.labelSpace[1] = 0.01;
        this.labelFont = new Font("SansSerif", 1, 14);
        this.gridColor = Color.GRAY;
        this.logScale = new boolean[2];
        this.logScale[0] = false;
        this.logScale[1] = false;
        this.ticLabel = new String[2][];
        this.ticNumber = new double[2][];
        this.numberOfTics = new int[2];
        this.numberOfTics[0] = 6;
        this.numberOfTics[1] = 6;
        this.numberOfTicsEstimated = new int[2];
        this.numberOfTicsEstimated[0] = this.numberOfTics[0];
        this.numberOfTicsEstimated[1] = this.numberOfTics[1];
        this.maxLabelWidth = new int[2];
        this.maxLabelHight = new int[2];
        this.diff = new double[2];
        this.inv = new double[2];
        this.axisLength = new double[2];
        this.ticLength = new double[2];
        this.ticLength[0] = 0.02;
        this.ticLength[1] = 0.02;
        this.subticLength = new double[2];
        this.subticLength[0] = 0.01;
        this.subticLength[1] = 0.01;
        this.subticNumber = new int[2];
        this.subticNumber[0] = 4;
        this.subticNumber[1] = 4;
        this.useTicLabels = new boolean[2];
        this.useTicLabels[0] = true;
        this.useTicLabels[1] = true;
        this.isContour = false;
        this.isContourBar = false;
        this.ContourBinX = 20;
        this.ContourBinY = 20;
        this.ContourLevels = 20;
        this.isContourGray = false;
        this.contour = null;
        this.h2d = null;
        this.AxisExponent = new int[2];
        this.backgroundColor = Color.WHITE;
        this.prepareAxis(0);
        this.prepareAxis(1);
        this.buildMargins();
    }

    public boolean isGridFront() {
        return this.isGridFront;
    }

    public void setGridFront(boolean isGridFront) {
        this.isGridFront = isGridFront;
    }

    public void setBackgroundColor(Color bkgColor) {
        this.backgroundColor = bkgColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private void buildMargins() {
        this.axisLength[0] = this.getWidth();
        this.axisLength[1] = this.getHeight();
        this.leftMargin = this.getX();
        this.rightMargin = this.leftMargin + this.axisLength[0];
        this.topMargin = this.getY();
        this.bottomMargin = (double)this.getY() + this.axisLength[1];
    }

    public double getMarginLeft() {
        return this.leftMargin;
    }

    public double getMarginRight() {
        return this.rightMargin;
    }

    public double getMarginTop() {
        return this.topMargin;
    }

    public double getMarginBottom() {
        return this.bottomMargin;
    }

    protected void prepareAxis(int axis) {
        this.setMinMax(axis);
        int Ntick = 1;
        int NtotT = this.numberOfTics[axis];
        Ntick = this.numberOfTics[axis];
        Vector<String> tics = Axis.computeTicks(this.min[axis], this.max[axis], Ntick, this.logScale[axis]);
        NtotT = tics.size();
        if (!this.logScale[axis] && NtotT < this.numberOfTics[axis] - 1) {
            tics = Axis.computeTicks(this.min[axis], this.max[axis], Ntick += 2, this.logScale[axis]);
            NtotT = tics.size();
        }
        if (this.logScale[axis]) {
            this.max[axis] = FastMath.log10((double)this.max[axis]);
            this.min[axis] = FastMath.log10((double)this.min[axis]);
        }
        this.diff[axis] = FastMath.abs((double)(this.max[axis] - this.min[axis]));
        if (this.logScale[axis]) {
            this.min[axis] = FastMath.pow((double)10.0, (double)this.min[axis]);
            this.max[axis] = FastMath.pow((double)10.0, (double)this.max[axis]);
        }
        this.inv[axis] = this.min[axis] < this.max[axis] ? 1.0 : -1.0;
        int Ntics = NtotT;
        this.ticLabel[axis] = new String[Ntics];
        this.ticNumber[axis] = new double[Ntics];
        this.AxisExponent[axis] = 0;
        if (!this.logScale[axis]) {
            this.AxisExponent[axis] = FastMath.abs((double)this.min[axis]) > FastMath.abs((double)this.max[axis]) ? (int)FastMath.floor((double)(FastMath.log10((double)Math.abs(this.min[axis])) / 3.0)) * 3 : (int)FastMath.floor((double)(FastMath.log10((double)Math.abs(this.max[axis])) / 3.0)) * 3;
            if (FastMath.abs((int)this.AxisExponent[axis]) <= this.expForm) {
                this.AxisExponent[axis] = 0;
            }
        }
        int N = 0;
        for (int i = 0; i < Ntics; ++i) {
            double ticval;
            String ticstr = tics.elementAt(i);
            double NoExpon = ticval = Double.parseDouble(ticstr);
            if (!this.logScale[axis]) {
                NoExpon = ticval / FastMath.pow((double)10.0, (int)this.AxisExponent[axis]);
                ticstr = Utils.FormNum(NoExpon, this.min[axis], this.max[axis]);
            } else {
                ticstr = Utils.FormLog(ticval);
            }
            this.ticNumber[axis][N] = ticval;
            this.ticLabel[axis][N] = ticstr;
            ++N;
        }
        this.numberOfTicsEstimated[axis] = N;
        this.ticLabel[axis] = Utils.skeepZero(this.ticLabel[axis]);
    }

    public void setExpForm(int expForm) {
        this.expForm = expForm;
    }

    public int getExpForm() {
        return this.expForm;
    }

    public void setLabelSpace(int axis, double labelSpace) {
        this.labelSpace[axis] = labelSpace;
    }

    public double getLabelSpace(int axis) {
        return this.labelSpace[axis];
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public void setSubTicksNumber(int axis, int maxSubTicks) {
        this.subticNumber[axis] = maxSubTicks;
    }

    public void setTicksNumber(int axis, int maxTicks) {
        this.numberOfTics[axis] = maxTicks;
    }

    public void setShowGrid(int axis, boolean showGrid) {
        this.showGrid[axis] = showGrid;
    }

    public void setShow(int axis, boolean show) {
        this.show[axis] = show;
    }

    public void setShowMirror(int axis, boolean showMirror) {
        this.showMirror[axis] = showMirror;
    }

    public void setTicksSize(int axis, double ticsSize) {
        this.ticLength[axis] = ticsSize;
    }

    public void setSubTicksSize(int axis, double subTicsSize) {
        this.subticLength[axis] = subTicsSize;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelRotation(double labelRotation) {
        this.labelRotation = labelRotation;
    }

    public double getLabelRotation() {
        return this.labelRotation;
    }

    public void setPad(int axis, int pad) {
        this.pad[axis] = pad;
    }

    public int getPad(int axis) {
        return this.pad[axis];
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public boolean getRotateTicks(int axis) {
        return this.rotateTic[axis];
    }

    public void setRotateTicks(int axis, boolean angle) {
        this.rotateTic[axis] = angle;
    }

    public int getSubTicksNumber(int axis) {
        return this.subticNumber[axis];
    }

    public int getTicksNumber(int axis) {
        return this.numberOfTics[axis];
    }

    protected int getTicksNE(int axis) {
        return this.numberOfTicsEstimated[axis];
    }

    public double getSubTicksSize(int axis) {
        return this.subticLength[axis];
    }

    public double getTicksSize(int axis) {
        return this.ticLength[axis];
    }

    public int getAxesArrow(int axis) {
        return this.axesArrow[axis];
    }

    public void setAxesArrow(int axis, int type) {
        this.axesArrow[axis] = type;
    }

    public boolean isTicksLabels(int axis) {
        return this.useTicLabels[axis];
    }

    public void setTicksLabels(int axis, boolean draw) {
        this.useTicLabels[axis] = draw;
    }

    public boolean isShowKey() {
        return this.isShowKey;
    }

    public void setShowKey(boolean show) {
        this.isShowKey = show;
    }

    public boolean isShow(int axis) {
        return this.show[axis];
    }

    public boolean isShowGrid(int axis) {
        return this.showGrid[axis];
    }

    public boolean isShowMirror(int axis) {
        return this.showMirror[axis];
    }

    public String axisExponent(int axis) {
        return Integer.toString(this.AxisExponent[axis]);
    }

    public void setContour(boolean isContour) {
        this.isContour = isContour;
        if (!this.isContour) {
            this.contour = null;
            this.h2d = null;
            return;
        }
    }

    public boolean isContour() {
        return this.isContour;
    }

    public void setContourBar(boolean bar) {
        this.isContourBar = bar;
    }

    public boolean isContourBar() {
        return this.isContourBar;
    }

    public int getContourBinX() {
        return this.ContourBinX;
    }

    public int getContourBinY() {
        return this.ContourBinY;
    }

    public int getContourLevels() {
        return this.ContourLevels;
    }

    public void setStatistics(String[] s) {
        this.statistics = s;
    }

    public String[] getStatistics() {
        return this.statistics;
    }

    public void setContourLevels(int levels) {
        this.ContourLevels = levels;
    }

    public void setContourBins(int binsX, int binsY) {
        this.ContourBinX = binsX;
        this.ContourBinY = binsY;
    }

    public void setContourGray(boolean gray) {
        this.isContourGray = gray;
    }

    private void setMinMax(int axis) {
        if (this.data == null) {
            return;
        }
        if (this.data.size() == 0) {
            return;
        }
        double min = this.getMin(axis);
        double max = this.getMax(axis);
        boolean isHisto = false;
        if (this.autoRange[axis]) {
            Enumeration<DataArray> e = this.data.elements();
            DataArray da = e.nextElement();
            if (da.getType() == 101) {
                isHisto = true;
            }
            double minVal = this.logScale[axis] ? da.getLowestNonZeroValue(axis) : da.getMinValue(axis);
            min = minVal;
            max = da.getMaxValue(axis);
            while (e.hasMoreElements()) {
                da = e.nextElement();
                minVal = this.logScale[axis] ? da.getLowestNonZeroValue(axis) : da.getMinValue(axis);
                if (minVal < min) {
                    min = minVal;
                }
                if (!(da.getMaxValue(axis) > max)) continue;
                max = da.getMaxValue(axis);
            }
            double del = max - min;
            if ((min -= (del = 0.05 * del)) == (max += del)) {
                min -= 0.1;
                max += 0.1;
            }
            if (isHisto && axis == 1) {
                min = 0.0;
                if (this.logScale[axis]) {
                    min = da.getLowestNonZeroValue(axis);
                }
            }
            if (axis == 0 && this.logScale[axis]) {
                min = da.getLowestNonZeroValue(axis);
            }
            if (this.logScale[axis]) {
                min = this.getLogBoundary(axis, min) / 10.0;
                max = this.getLogBoundary(axis, max);
            }
        }
        double tic = this.calculateTicSep(axis, min, max);
        if (this.autoRange[axis]) {
            if (min < max) {
                min = tic * FastMath.floor((double)(min / tic));
                max = tic * FastMath.ceil((double)(max / tic));
            } else {
                min = tic * FastMath.ceil((double)(min / tic));
                max = tic * FastMath.floor((double)(max / tic));
            }
        }
        this.setMin(axis, min);
        this.setMax(axis, max);
    }

    public void setData(Vector<DataArray> data) {
        this.data = data;
    }

    public int toX(double x) {
        double d = this.logScale[0] ? FastMath.log10((double)(x / this.min[0])) : x - this.min[0];
        return (int)((double)this.getX() + this.inv[0] * d * (double)this.getWidth() / this.diff[0]);
    }

    public double toUserX(int Xpic) {
        double scale = (double)this.getWidth() / this.diff[0];
        double d = (double)(Xpic - this.getX()) / (this.inv[0] * scale);
        double mPosX = this.logScale[0] ? FastMath.pow((double)10.0, (double)d) * this.min[0] : d + this.min[0];
        return mPosX;
    }

    public int toY(double y) {
        double d = this.logScale[1] ? FastMath.log10((double)(y / this.min[1])) : y - this.min[1];
        return (int)((double)this.getY() + (double)this.getHeight() * (1.0 - this.inv[1] * d / this.diff[1]));
    }

    public double toUserY(int Ypic) {
        double scale = (double)this.getHeight() / this.diff[1];
        double d = (double)(-1 * Ypic + this.getY() + this.getHeight()) / (scale * this.inv[1]);
        double mPosY = this.logScale[1] ? FastMath.pow((double)10.0, (double)d) * this.min[1] : d + this.min[1];
        return mPosY;
    }

    public void setTicLabel(String[][] ticLabel) {
        this.ticLabel = ticLabel;
    }

    public String[][] getTicLabel() {
        return this.ticLabel;
    }

    public void setLogScale(int axis, boolean set) {
        this.logScale[axis] = set;
        if (set && this.subticNumber[axis] < 10) {
            this.subticNumber[axis] = 10;
        }
        this.prepareAxis(axis);
    }

    public boolean isLogScale(int axis) {
        return this.logScale[axis];
    }

    public void setAutoRange(int axis, boolean autoRange) {
        this.autoRange[axis] = autoRange;
        this.prepareAxis(axis);
    }

    public void setAutoRange() {
        this.autoRange[0] = true;
        this.autoRange[1] = true;
        this.prepareAxis(0);
        this.prepareAxis(1);
    }

    public boolean isAutoRange(int axis) {
        return this.autoRange[axis];
    }

    public void setRange(int axis, double minValue, double maxValue) {
        default_AXES = false;
        this.min[axis] = minValue;
        this.max[axis] = maxValue;
        this.autoRange[axis] = false;
        this.prepareAxis(axis);
    }

    public void setMax(int axis, double value) {
        default_AXES = false;
        this.max[axis] = value;
    }

    public void setMin(int axis, double value) {
        default_AXES = false;
        this.min[axis] = value;
    }

    public double getMax(int axis) {
        return this.max[axis];
    }

    public double getMin(int axis) {
        return this.min[axis];
    }

    @Override
    public final JaObject copy() {
        JaAxes temp = new JaAxes(0, 0);
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setX(this.getX());
        temp.setY(this.getY());
        temp.setGridFront(this.isGridFront);
        temp.setGridColor(this.gridColor);
        temp.setLabelColor(this.labelColor);
        temp.setLabelFont(this.labelFont);
        temp.setLabelRotation(this.labelRotation);
        temp.setExpForm(this.expForm);
        temp.setColor(this.getColor());
        temp.setFillColor(this.getFillColor());
        temp.setStroke(this.getStroke());
        temp.setSize(this.getWidth(), this.getHeight(), this.getRelw(), this.getRelh());
        temp.setBoundingBox(this.getBoundingBox());
        for (int i = 0; i < 2; ++i) {
            temp.setPad(i, this.pad[i]);
            temp.setMin(i, this.min[i]);
            temp.setMax(i, this.max[i]);
            temp.setSubTicksSize(i, this.subticLength[i]);
            temp.setAutoRange(i, this.autoRange[i]);
            temp.setTicksSize(i, this.ticLength[i]);
            temp.setSubTicksNumber(i, this.subticNumber[i]);
            temp.setTicksNumber(i, this.numberOfTics[i]);
            temp.setShowGrid(i, this.showGrid[i]);
            temp.setShow(i, this.show[i]);
            temp.setShowMirror(i, this.showMirror[i]);
            temp.setLabelSpace(i, this.labelSpace[i]);
            temp.setRotateTicks(i, this.rotateTic[i]);
        }
        return temp;
    }

    @Override
    public final boolean isCopy(JaObject comp) {
        JaAxes temp;
        boolean isCopy = false;
        if (comp instanceof JaAxes && (temp = (JaAxes)comp).getX() == this.getX() && temp.getY() == this.getY() && temp.getColor().equals(this.getColor()) && temp.getFillColor().equals(this.getFillColor()) && temp.getStroke() == this.getStroke() && temp.getMin(0) == this.getMin(0) && temp.getMin(1) == this.getMin(1) && temp.getMax(0) == this.getMax(0) && temp.getMax(1) == this.getMax(1) && temp.getRelw() == this.getRelw() && temp.getRelh() == this.getRelh()) {
            isCopy = true;
        }
        return isCopy;
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, int editmode) {
        if (editmode == 50 || editmode == 52) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 11;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 11;
            }
            return 0;
        }
        if (editmode == 51) {
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 14;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() + this.getHeight() && clickY <= this.getY() + this.getHeight() + 8) {
                return 15;
            }
            if (clickX >= this.getX() + this.getWidth() && clickX <= this.getX() + this.getWidth() + 8 && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 13;
            }
            if (clickX >= this.getX() - 8 && clickX <= this.getX() && clickY >= this.getY() - 8 && clickY <= this.getY()) {
                return 12;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void drawHandles(VectorGraphics g2) {
        g2.setColor(JaxoColor.RED);
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        g2.drawRect(x - 8, y - 8, 8, 8);
        g2.drawRect(x - 8, y + height, 8, 8);
        g2.drawRect(x + width, y - 8, 8, 8);
        g2.drawRect(x + width, y + height, 8, 8);
        if (this.isMarked()) {
            g2.setColor(JaxoColor.GRAYSCALE150);
            g2.fillRect(x - 8 + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x - 8 + 1, y + height + 1, 7, 7);
            g2.fillRect(x + width + 1, y - 8 + 1, 7, 7);
            g2.fillRect(x + width + 1, y + height + 1, 7, 7);
        }
    }

    public void getLabelDimension(FontMetrics fmX, int axis) {
        float wid = 0.0f;
        float wLabel = 0.0f;
        for (int i = 0; i < this.numberOfTicsEstimated[axis]; ++i) {
            if (this.ticLabel[axis][i] == null || !((wid = (float)fmX.stringWidth(this.ticLabel[axis][i])) > wLabel)) continue;
            wLabel = wid;
        }
        this.maxLabelWidth[axis] = (int)wLabel;
        this.maxLabelHight[axis] = fmX.getHeight();
    }

    protected double calculateTicSep(int axis, double min, double max) {
        double fl;
        double lrange = FastMath.log10((double)FastMath.abs((double)(min - max)));
        double xnorm = FastMath.pow((double)10.0, (double)(lrange - (fl = FastMath.floor((double)lrange))));
        double posns = (double)this.numberOfTicsEstimated[axis] / xnorm;
        double tic = posns > 40.0 ? 0.05 : (posns > 20.0 ? 0.1 : (posns > 10.0 ? 0.2 : (posns > 4.0 ? 0.5 : (posns > 1.0 ? 1.0 : (posns > 0.5 ? 2.0 : (posns > 0.2 ? 10.0 : FastMath.ceil((double)xnorm)))))));
        return tic *= FastMath.pow((double)10.0, (double)fl);
    }

    public Vector<DataArray> getData() {
        return this.data;
    }

    public int getNumDigits(double num) {
        int numDigits;
        if (num == 0.0) {
            return 0;
        }
        for (numDigits = 0; numDigits <= 15 && FastMath.abs((double)(FastMath.floor((double)num) / num - 1.0)) > 1.0E-10; ++numDigits) {
            num *= 10.0;
        }
        return numDigits;
    }

    public String formatNumber(double num, int n) {
        int maxFloat = 6;
        if (num != 0.0) {
            int exp = (int)FastMath.floor((double)FastMath.log10((double)num));
            int x = FastMath.abs((int)exp) + n;
            BigDecimal bd = new BigDecimal(num);
            if (x > maxFloat) {
                bd = exp > 0 ? bd.movePointLeft(exp) : bd.movePointRight(FastMath.abs((int)exp));
            } else {
                n = exp < 0 ? x : x - FastMath.abs((int)exp);
            }
            bd = bd.setScale(n, 6);
            int nn = this.getNumDigits(bd.doubleValue());
            if (nn < n) {
                bd = bd.setScale(nn);
            }
            String res = bd.toString();
            if (x > maxFloat) {
                res = res + "e" + exp;
            }
            return res;
        }
        return "0";
    }

    @Override
    public final void jaxoDraw(VectorGraphics g2, boolean drawToScreen) {
        this.buildMargins();
        FontMetrics fm = g2.getFontMetrics(this.labelFont);
        GeneralPath gp = this.getGeneralPath();
        if (gp == null) {
            return;
        }
        gp.reset();
        Rectangle2D.Double box = new Rectangle2D.Double();
        box.setFrame(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        gp.append(box, false);
        g2.setColor(this.getFillColor());
        g2.setStroke((Stroke)new BasicStroke(1.0f));
        g2.fill((Shape)gp);
        gp.reset();
        this.getLabelDimension(fm, 0);
        this.getLabelDimension(fm, 1);
        int ylab = Global.fromY((float)this.labelSpace[0]) + this.maxLabelHight[0];
        int xlab = Global.fromX((float)this.labelSpace[1]) + this.maxLabelWidth[1];
        int last_label = this.numberOfTicsEstimated[0] - 1;
        int xlab_right = (int)(0.5 * (double)fm.stringWidth(this.ticLabel[0][last_label]));
        DrawAxesTics.drawAxes(this, g2, gp);
        if (box != null) {
            g2.draw((Shape)box);
        }
        g2.setColor(this.getColor());
        g2.setStroke((Stroke)new BasicStroke(this.getStroke()));
        g2.draw((Shape)gp);
        Rectangle2D.Float pad = new Rectangle2D.Float();
        int xw = this.getWidth();
        if (this.isContour) {
            xw += this.contour.getFullBarWidth();
        }
        int xshift = xlab + 4;
        int yshift = ylab + 2;
        pad.setFrame(this.getX() - xshift, this.getY() - (int)(0.5 * (double)yshift), xw + xshift + 2 + xlab_right, this.getHeight() + 2 * yshift);
        gp.append(pad, false);
        Rectangle2D bb = gp.getBounds2D();
        double[] bbox = new double[]{bb.getMinX(), bb.getMinY(), bb.getMaxX(), bb.getMaxY()};
        this.setBoundingBox(bbox);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D lowerCorner = this.getLaTexLowerCorner(scale, canvasHeight);
        Point2D upperCorner = this.getLaTexUpperCorner(scale, canvasHeight);
        String command = "";
        if ((int)lowerCorner.getX() == (int)upperCorner.getX() && (int)lowerCorner.getY() == (int)upperCorner.getY()) {
            command = "%";
        } else if (JaxoColor.isGrayScale(this.getFillColor())) {
            String grayScale = JaxoColor.getGreyScale(this.getFillColor());
            command = "\\GAxes(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + grayScale + "}";
        } else {
            String tlc = JaxoColor.getColorName(this.getColor());
            String tfc = JaxoColor.getColorName(this.getFillColor());
            command = "\\CAxes(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + "){" + tlc + "}{" + tfc + "}";
        }
        return command;
    }

    protected double getLogBoundary(int axis, double v) {
        double k;
        double x = 10.0;
        if (v > 1.0) {
            for (k = 0.0; v >= 1.0 && k < 299.0; v /= 10.0, k += 1.0) {
            }
        } else {
            x = 0.1;
            while (v <= 0.1 && k < 299.0) {
                v *= 10.0;
                k += 1.0;
            }
        }
        return FastMath.pow((double)x, (double)k);
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        int newRelWidth = FastMath.round((float)((float)this.getRelSize().width * scale));
        int newRelHeight = FastMath.round((float)((float)this.getRelSize().height * scale));
        Point2D newP = this.scalePoint(orx, ory, scale, this.getX(), this.getY());
        this.setX((int)FastMath.round((double)newP.getX()));
        this.setY((int)FastMath.round((double)newP.getY()));
        this.setRelWAndH(newRelWidth, newRelHeight);
    }

    private Point2D getLaTexLowerCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float lowerCornerVec = new Point2D.Float();
        float x1 = this.getX();
        float y1 = this.getY() + this.getHeight();
        ((Point2D)lowerCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return lowerCornerVec;
    }

    private Point2D getLaTexUpperCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float upperCornerVec = new Point2D.Float();
        float x1 = this.getX() + this.getWidth();
        float y1 = this.getY();
        ((Point2D)upperCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return upperCornerVec;
    }

    public void addData(DataArray d, int plotType) {
        this.data.add(d);
        this.plotType = plotType;
        this.h2d = null;
        this.prepareAxis(0);
        this.prepareAxis(1);
        if (this.isContour && this.plotType == 2) {
            this.parseContour();
        }
    }

    public void addData(H2D h2d, int plotType) {
        this.plotType = plotType;
        this.h2d = h2d;
        if (this.isContour && this.plotType == 201) {
            this.setAutoRange(0, false);
            this.setAutoRange(1, false);
            if (default_AXES) {
                this.min[0] = h2d.getMinX();
                this.min[1] = h2d.getMinY();
                this.max[0] = h2d.getMaxX();
                this.max[1] = h2d.getMaxY();
            }
            this.prepareAxis(0);
            this.prepareAxis(1);
            this.parseH2D();
        }
    }

    public void parseContour() {
        Enumeration<DataArray> e = this.data.elements();
        while (e.hasMoreElements()) {
            DataArray da = e.nextElement();
            if (da.size() == 0) continue;
            this.contour = new Contour(this.isContourBar, this.ContourBinX, this.ContourBinY, this.isContourGray, this.ContourLevels);
            this.contour.createGrid(da.getData(), this.min[0], this.max[0], this.min[1], this.max[1]);
            break;
        }
    }

    public void parseH2D() {
        this.contour = new Contour(this.isContourBar, this.ContourBinX, this.ContourBinY, this.isContourGray, this.ContourLevels);
        this.contour.setHistogram(this.h2d);
        this.contour.createGrid(this.min[0], this.max[0], this.min[1], this.max[1]);
    }

    public void clear() {
        this.data.clear();
    }

    protected void fillGraphArea(VectorGraphics g2) {
        rect.setRect(this.leftMargin, this.topMargin, this.axisLength[0], this.axisLength[1]);
        g2.setColor(this.getFillColor());
        g2.fill((Shape)rect);
    }

    public int getPlotType() {
        return this.plotType;
    }

    public void drawData(VectorGraphics g2) {
        if (this.isGridFront) {
            DrawGrid.draw(this, g2);
        }
        if (this.plotType == 201 && this.h2d != null) {
            DrawContour.draw(this, g2, this.h2d);
            if (!this.isGridFront) {
                DrawGrid.draw(this, g2);
            }
            DrawAxesTics.redraw(this, g2);
            return;
        }
        if (this.data == null) {
            return;
        }
        Enumeration<DataArray> e = this.data.elements();
        while (e.hasMoreElements()) {
            DataArray da = e.nextElement();
            if (da.size() == 0) continue;
            if (this.isContour) {
                DrawContour.draw(this, g2, da);
                continue;
            }
            DrawGraph_2D.draw(this, g2, da);
        }
        if (!this.isGridFront) {
            DrawGrid.draw(this, g2);
        }
        DrawAxesTics.redraw(this, g2);
    }

    private boolean inRange(double x, double y) {
        return !(x < this.leftMargin || x > this.leftMargin + this.axisLength[0] || y < this.topMargin) && !(y > this.topMargin + this.axisLength[1]);
    }

    private boolean inRangeFrame(double x, double y) {
        return !(x < 0.0) && !(x > (double)this.getWidth()) && !(y > (double)this.getHeight());
    }

    public Vector<PlotPoint> getPoints(DataArray da) {
        Vector data = da.getData();
        double oldX = 0.0;
        Vector<PlotPoint> p = new Vector<PlotPoint>();
        int i = 0;
        double aXmin = this.leftMargin;
        double aXmax = this.leftMargin + this.axisLength[0];
        double aYmin = this.topMargin + this.axisLength[1];
        double aYmax = this.topMargin;
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            PlotPoint pp = (PlotPoint)e.nextElement();
            double x = this.toX(pp.getX());
            double y = this.toY(pp.getY());
            double left = this.toX(pp.getX() - pp.getXleft());
            double right = this.toX(pp.getX() + pp.getXright());
            double upper = this.toY(pp.getY() + pp.getYupper());
            double lower = this.toY(pp.getY() - pp.getYlower());
            double left_sys = this.toX(pp.getX() - pp.getXleft() - pp.getXleftSys());
            double right_sys = this.toX(pp.getX() + pp.getXright() + pp.getXrightSys());
            double upper_sys = this.toY(pp.getY() + pp.getYupper() + pp.getYupperSys());
            double lower_sys = this.toY(pp.getY() - pp.getYlower() - pp.getYlowerSys());
            if (!(da.getGraphStyle() != 1 && (right_sys < aXmin - 1.0 || left_sys > aXmax + 1.0 || lower_sys < aYmax - 1.0 || upper_sys > aYmin + 1.0) || da.getGraphStyle() == 1 && (right_sys < aXmin - 1.0 || left_sys > aXmax + 1.0))) {
                if (y < this.topMargin) {
                    y = this.topMargin;
                }
                if (x < this.leftMargin) {
                    x = this.leftMargin;
                }
                if (x > this.leftMargin + this.axisLength[0]) {
                    x = this.leftMargin + this.axisLength[0];
                }
                if (y > this.topMargin + this.axisLength[1]) {
                    y = this.topMargin + this.axisLength[1];
                }
                if (this.inRange(x, y)) {
                    p.add(new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
                }
            }
            ++i;
        }
        return p;
    }

    public Vector<PlotPoint> getPointsNoCuts(DataArray da) {
        Vector data = da.getData();
        Vector<PlotPoint> p = new Vector<PlotPoint>();
        int i = 0;
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            PlotPoint pp = (PlotPoint)e.nextElement();
            double x = this.toX(pp.getX());
            double y = this.toY(pp.getY());
            double left = this.toX(pp.getX() - pp.getXleft());
            double right = this.toX(pp.getX() + pp.getXright());
            double upper = this.toY(pp.getY() + pp.getYupper());
            double lower = this.toY(pp.getY() - pp.getYlower());
            double left_sys = this.toX(pp.getX() - pp.getXleft() - pp.getXleftSys());
            double right_sys = this.toX(pp.getX() + pp.getXright() + pp.getXrightSys());
            double upper_sys = this.toY(pp.getY() + pp.getYupper() + pp.getYupperSys());
            double lower_sys = this.toY(pp.getY() - pp.getYlower() - pp.getYlowerSys());
            p.add(new PlotPoint(x, y, left, right, upper, lower, left_sys, right_sys, upper_sys, lower_sys));
            ++i;
        }
        return p;
    }

    public void drawMargins(VectorGraphics g2) {
        double x = this.leftMargin + this.axisLength[0];
        double y = this.topMargin + this.axisLength[1];
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(this.backgroundColor);
        g2.fillRect(0.0, 0.0, (double)width + this.rightMargin + this.leftMargin, this.topMargin);
    }

    @Override
    public final boolean editPanel() {
        JaAxesOptionsPanel boxop = new JaAxesOptionsPanel(this);
        return boxop.hasChanged();
    }

    protected void mess(String s, double d) {
        System.out.println("Debug: " + s + Double.toString(d));
    }

    protected void mess(String s, int d) {
        System.out.println("Debug: " + s + Integer.toString(d));
    }

    protected void mess(String s) {
        System.out.println("Debug: " + s);
    }

    protected void error(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

