/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoZoom;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class JaxoZoomPopupMenu
extends JPopupMenu
implements ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoMainPanel thePanel;
    private JMenu zoomFactorM;
    private JRadioButtonMenuItem zoomBFactor1;
    private JRadioButtonMenuItem zoomBFactor2;
    private JRadioButtonMenuItem zoomBFactor3;
    private ButtonGroup zoomFactorGroup;
    private static final int ZOOM_FACTOR_X2 = 2;
    private static final int ZOOM_FACTOR_X4 = 4;
    private static final int ZOOM_FACTOR_X8 = 8;

    public JaxoZoomPopupMenu(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        this.zoomFactorM = new JMenu(this.language.getString("Zoom_factor"));
        this.zoomFactorM.addActionListener(this);
        this.zoomFactorM.setActionCommand("ZoomFactor");
        this.zoomFactorGroup = new ButtonGroup();
        this.zoomBFactor1 = new JRadioButtonMenuItem("2x");
        this.zoomBFactor1.addActionListener(this);
        this.zoomBFactor1.setActionCommand("2x");
        this.zoomBFactor2 = new JRadioButtonMenuItem("4x");
        this.zoomBFactor2.addActionListener(this);
        this.zoomBFactor2.setActionCommand("4x");
        this.zoomBFactor3 = new JRadioButtonMenuItem("8x");
        this.zoomBFactor3.addActionListener(this);
        this.zoomBFactor3.setActionCommand("8x");
        this.zoomFactorGroup.add(this.zoomBFactor1);
        this.zoomFactorGroup.add(this.zoomBFactor2);
        this.zoomFactorGroup.add(this.zoomBFactor3);
        this.zoomFactorM.add(this.zoomBFactor1);
        this.zoomFactorM.add(this.zoomBFactor2);
        this.zoomFactorM.add(this.zoomBFactor3);
        this.zoomBFactor1.setSelected(true);
        this.add(this.zoomFactorM);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        AbstractButton source = (AbstractButton)evt.getSource();
        JaxoZoom zoom = this.thePanel.getZoom();
        if (source.getActionCommand().equals("2x")) {
            zoom.setZoomFactor(2);
        } else if (source.getActionCommand().equals("4x")) {
            zoom.setZoomFactor(4);
        } else if (source.getActionCommand().equals("8x")) {
            zoom.setZoomFactor(8);
        }
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.zoomFactorM.setText(this.language.getString("Zoom_factor"));
    }
}

