/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import jhplot.jadraw.JaObject;

public class JaxoSaveGraph
implements Serializable {
    private ArrayList objectList;
    private String description;
    private ArrayList packageList;
    public static final int LIST_INIT_SIZE = 5;

    public JaxoSaveGraph() {
        this.objectList = new ArrayList(5);
        this.description = "";
        this.packageList = new ArrayList(5);
        this.packageList.add("axodraw");
        this.packageList.add("pstricks");
        this.packageList.add("color");
    }

    public JaxoSaveGraph(ArrayList list) {
        this.objectList = list;
        this.description = "";
        this.packageList = new ArrayList(5);
        this.packageList.add("axodraw");
        this.packageList.add("pstricks");
        this.packageList.add("color");
    }

    public JaxoSaveGraph(ArrayList list, String describe) {
        this.objectList = list;
        this.description = describe;
        this.packageList = new ArrayList(5);
        this.packageList.add("axodraw");
        this.packageList.add("pstricks");
        this.packageList.add("color");
    }

    public final ArrayList getObjectList() {
        return this.objectList;
    }

    public final void setObjectList(ArrayList list) {
        this.objectList = list;
    }

    public final ArrayList getPackageList() {
        return this.packageList;
    }

    public final void reverse() {
        Collections.reverse(this.objectList);
    }

    public final void setPackageList(ArrayList list) {
        this.packageList = list;
    }

    public final void setDescription(String describe) {
        this.description = describe;
    }

    public final String getDescription() {
        return this.description;
    }

    public final JaObject listElementAt(int i) {
        if (i <= this.listSize()) {
            return (JaObject)this.objectList.get(i);
        }
        return null;
    }

    public final int listSize() {
        return this.objectList.size();
    }

    public final boolean foreground(JaObject object) {
        boolean isLastElement = true;
        int i = this.objectList.indexOf(object);
        if (i != this.objectList.size() - 1) {
            this.objectList.remove(i);
            this.objectList.add(object);
            isLastElement = false;
        }
        return isLastElement;
    }

    public final boolean background(JaObject object) {
        boolean isFirstElement = true;
        int i = this.objectList.indexOf(object);
        if (i != 0) {
            this.objectList.remove(i);
            this.objectList.add(0, object);
            isFirstElement = false;
        }
        return isFirstElement;
    }

    public final void delete(JaObject object) {
        if (this.objectList.contains(object)) {
            this.objectList.remove(this.objectList.indexOf(object));
        }
    }

    public final void addObject(JaObject object) {
        this.objectList.add(object);
    }

    public final void addFirst(JaObject object) {
        if (this.objectList.size() == 0) {
            this.objectList.add(object);
        }
        this.objectList.add(0, object);
    }

    public final boolean clear() {
        boolean listIsEmpty = this.objectList.isEmpty();
        if (!listIsEmpty) {
            this.objectList.clear();
        }
        return listIsEmpty;
    }

    public final boolean clearAll() {
        boolean graphIsEmpty = false;
        if (this.objectList.isEmpty() && this.description.length() == 0) {
            graphIsEmpty = true;
        } else {
            this.objectList.clear();
            this.setDescription("");
            graphIsEmpty = false;
        }
        return graphIsEmpty;
    }

    public final double[] getBoundingBox() {
        double minX = 0.0;
        double maxX = 1.0;
        double minY = 0.0;
        double maxY = 1.0;
        double[] bBox = new double[]{minX, minY, maxX, maxY};
        int length = this.objectList.size();
        for (int i = 0; i < length; ++i) {
            JaObject ob = (JaObject)this.objectList.get(i);
            bBox = ob.getBoundingBox();
            if (i == 0) {
                minX = bBox[0];
                minY = bBox[1];
                maxX = bBox[2];
                maxY = bBox[3];
                continue;
            }
            if (bBox[0] < minX) {
                minX = bBox[0];
            }
            if (bBox[1] < minY) {
                minY = bBox[1];
            }
            if (bBox[2] > maxX) {
                maxX = bBox[2];
            }
            if (!(bBox[3] > maxY)) continue;
            maxY = bBox[3];
        }
        bBox[0] = minX;
        bBox[1] = minY;
        bBox[2] = maxX;
        bBox[3] = maxY;
        return bBox;
    }
}

