/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.Plot;
import japlot.jaxodraw.JaxoActionButtons;
import japlot.jaxodraw.JaxoCanvas;
import japlot.jaxodraw.JaxoEditButtons;
import japlot.jaxodraw.JaxoEditMenu;
import japlot.jaxodraw.JaxoExportPanel;
import japlot.jaxodraw.JaxoFileMenu;
import japlot.jaxodraw.JaxoFlags;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoGridButtons;
import japlot.jaxodraw.JaxoHelpMenu;
import japlot.jaxodraw.JaxoIO;
import japlot.jaxodraw.JaxoMiscButtons;
import japlot.jaxodraw.JaxoOptionsMenu;
import japlot.jaxodraw.JaxoParticleButtons;
import japlot.jaxodraw.JaxoPrefs;
import japlot.jaxodraw.JaxoPreview;
import japlot.jaxodraw.JaxoTabbedCanvasPanel;
import japlot.jaxodraw.JaxoToolBar;
import japlot.jaxodraw.JaxoZoom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jhplot.HPlotJa;
import jhplot.io.BrowserDataGeneric;
import jhplot.io.images.ExportVGraphics;
import jhplot.jadraw.JaLatexText;
import jhplot.jadraw.JaObject;
import jhplot.utils.HelpDialog;
import org.freehep.graphics2d.VectorGraphics;

public class JaxoMainPanel
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final int STANDBY = 0;
    public static final int FLINE = 3;
    public static final int FLOOP = 4;
    public static final int FARC = 5;
    public static final int SLINE = 6;
    public static final int GLINE = 9;
    public static final int SLOOP = 7;
    public static final int GLOOP = 10;
    public static final int SARC = 8;
    public static final int GARC = 11;
    public static final int PLINE = 12;
    public static final int PLOOP = 13;
    public static final int PARC = 14;
    public static final int GLLINE = 15;
    public static final int GLLOOP = 16;
    public static final int GLARC = 17;
    public static final int BOX = 30;
    public static final int BLOB = 31;
    public static final int VERTEX = 32;
    public static final int ZIGZAG = 33;
    public static final int TEXT = 34;
    public static final int LATEX = 35;
    public static final int VERTEXT1 = 36;
    public static final int VERTEXT2 = 37;
    public static final int VERTEXT3 = 38;
    public static final int VERTEXT4 = 39;
    public static final int VERTEXT5 = 40;
    public static final int VERTEXT6 = 41;
    public static final int UNDO = 42;
    public static final int CLEAR = 43;
    public static final int QUIT = 44;
    public static final int REFRESH = 45;
    public static final int PASTE = 46;
    public static final int ZOOM = 47;
    public static final int MOVE = 50;
    public static final int RESIZE = 51;
    public static final int COPY = 52;
    public static final int COLOR = 53;
    public static final int EDIT = 54;
    public static final int DELETE = 55;
    public static final int BACKGROUND = 56;
    public static final int FOREGROUND = 57;
    public static final int GROUP = 58;
    public static final int UNGROUP = 59;
    public static final int NEWG = 70;
    public static final int OPEN = 71;
    public static final int SAVE = 72;
    public static final int SAVE_AS = 73;
    public static final int DESCRIBE = 74;
    public static final int EXPORT = 75;
    public static final int PRINT = 76;
    public static final int PREVIEW = 77;
    public static final int CLOSE = 78;
    public static final int NEWT = 80;
    public static final int PACKAGE = 79;
    public static final int IMPORT = 81;
    public static final int OPENDATA = 82;
    public static final int DUMMIE = 10000;
    public static final int DUMMIE1 = 10001;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaxoParticleButtons pbtpanel;
    private JaxoEditButtons ebtpanel;
    private JaxoMiscButtons mbtpanel;
    private JaxoActionButtons abtpanel;
    private JaxoGridButtons gbtpanel;
    private JaxoFileMenu filemenu;
    private JaxoEditMenu editmenu;
    private JaxoOptionsMenu optionsmenu;
    private JaxoHelpMenu helpmenu;
    private JaxoToolBar toolbar;
    private JaxoFlags flagpanel;
    private int currentMode;
    private JToolBar jToolBar;
    private int currentVertex;
    private String[] envFonts;
    private boolean watchMode = false;
    private final String help_file = "japlot";
    private JaxoZoom zoom;
    private JaxoTabbedCanvasPanel canvasPanel;
    private JaxoGraph clipboard = new JaxoGraph();
    private boolean snap = false;
    private HPlotJa japlot;
    private static final String rootKey = JaxoMainPanel.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";

    public JaxoMainPanel(HPlotJa japlot) {
        this.japlot = japlot;
    }

    public HPlotJa getJaPlot() {
        return this.japlot;
    }

    public final void init(String inputFileName, JaxoGraph fGraph) {
        this.currentMode = 0;
        this.currentVertex = 36;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JaxoMainPanel.this.filemenu.quit();
            }
        });
        ImageIcon icone = new ImageIcon(this.getClass().getClassLoader().getResource("jhplot/images/logo_jhepwork_24x24.jpg"));
        this.setIconImage(icone.getImage());
        this.pbtpanel = new JaxoParticleButtons(this);
        this.ebtpanel = new JaxoEditButtons(this);
        this.mbtpanel = new JaxoMiscButtons(this);
        this.abtpanel = new JaxoActionButtons(this);
        Box btPanel = new Box(1);
        btPanel.add(this.pbtpanel);
        btPanel.add(this.mbtpanel);
        btPanel.add(this.abtpanel);
        btPanel.add(this.ebtpanel);
        this.jToolBar = new JToolBar(null, 1);
        this.jToolBar.setLayout(new BorderLayout());
        this.jToolBar.add(btPanel);
        this.flagpanel = new JaxoFlags(this);
        this.toolbar = new JaxoToolBar(this);
        JaxoGraph firstGraph = fGraph;
        if (firstGraph == null) {
            firstGraph = new JaxoGraph();
        }
        if (inputFileName != null && inputFileName.length() != 0) {
            block7: {
                File inputFile = new File(inputFileName);
                inputFileName = inputFile.getAbsolutePath();
                try {
                    firstGraph = JaxoIO.open(inputFileName);
                    firstGraph.setSaveFileName(inputFileName);
                    firstGraph.setSaved(true);
                }
                catch (NullPointerException e) {
                    JOptionPane.showMessageDialog(null, this.language.getString("NullPointerException:_Cannot_open_file_") + inputFileName);
                    if (!JaxoPrefs.verbose()) break block7;
                    System.err.println(e);
                }
            }
            this.setFlagPanelFileName(inputFileName);
        }
        firstGraph.setBackupSelectedObject(null);
        firstGraph.setSelectedObject(null);
        JaxoCanvas firstCanvas = new JaxoCanvas(this);
        firstCanvas.setCanvasGraph(firstGraph);
        firstCanvas.addMouseMotionListener(firstCanvas);
        firstCanvas.addMouseListener(firstCanvas);
        if (firstGraph.getShortName().length() != 0) {
            int lp = firstGraph.getShortName().lastIndexOf(".");
            String fileName = lp != -1 ? firstGraph.getShortName().substring(0, lp) : firstGraph.getShortName();
            firstCanvas.setCanvasTick(fileName);
        } else {
            firstCanvas.setCanvasTick(this.language.getString("Untitled"));
        }
        this.canvasPanel = new JaxoTabbedCanvasPanel(this);
        this.canvasPanel.registerTitle(firstCanvas.getCanvasTick());
        this.canvasPanel.add(this.canvasPanel.getIndexedTitle(firstCanvas.getCanvasTick()), firstCanvas).setName(firstCanvas.getCanvasTick());
        this.canvasPanel.setSelectedComponent(firstCanvas);
        for (int i = 0; i < firstGraph.listSize(); ++i) {
            JaObject jaxoOb = firstGraph.listElementAt(i);
            if (!(jaxoOb instanceof JaLatexText)) continue;
            ((JaLatexText)jaxoOb).createLatexPanel();
            firstCanvas.add(((JaLatexText)jaxoOb).getLatexPanel());
            ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
        }
        this.filemenu = new JaxoFileMenu(this);
        this.editmenu = new JaxoEditMenu(this);
        this.optionsmenu = new JaxoOptionsMenu(this);
        this.helpmenu = new JaxoHelpMenu(this);
        JMenuBar jaxomenubar = new JMenuBar();
        jaxomenubar.add(this.filemenu);
        jaxomenubar.add(this.editmenu);
        jaxomenubar.add(this.optionsmenu);
        jaxomenubar.add(this.helpmenu);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.canvasPanel, "Center");
        this.setJMenuBar(jaxomenubar);
        this.getContentPane().add((Component)this.jToolBar, "West");
        this.getContentPane().add((Component)this.flagpanel, "South");
        this.zoom = new JaxoZoom();
        this.applyPrefs();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public final void windowClosing(WindowEvent we) {
                JaxoMainPanel.this.fileEvent(44);
            }
        });
    }

    public void setGraph(JaxoGraph graph) {
        graph.setSaveFileName("Untitled");
        graph.setBackupSelectedObject(null);
        graph.setSelectedObject(null);
        this.filemenu.open(graph);
    }

    public final int getMode() {
        return this.currentMode;
    }

    public final void setMode(int newMode) {
        this.currentMode = newMode;
    }

    public final JaxoCanvas getCanvas() {
        return (JaxoCanvas)this.canvasPanel.getSelectedComponent();
    }

    public final boolean isEditMode() {
        boolean iem = true;
        if (this.currentMode < 50 || this.currentMode > 70) {
            iem = false;
        }
        return iem;
    }

    public final boolean isParticleMode() {
        boolean ipm = true;
        if (this.currentMode > 20 || this.currentMode < 3) {
            ipm = false;
        }
        return ipm;
    }

    public final boolean isMiscMode() {
        boolean imm = true;
        if (this.currentMode < 30 || this.currentMode > 36) {
            imm = false;
        }
        return imm;
    }

    public final void reset() {
        JaObject jaxoOb;
        int i;
        JaxoCanvas actCan = this.getCanvas();
        if (actCan == null) {
            return;
        }
        actCan.clearOffScreenImage();
        VectorGraphics g2 = (VectorGraphics)actCan.getOffScreenImage().getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JaxoGraph actCanGraph = actCan.getCanvasGraph();
        for (i = 0; i < actCanGraph.listSize(); ++i) {
            jaxoOb = actCanGraph.listElementAt(i);
            if (!Plot.drawFirst(jaxoOb)) continue;
            jaxoOb.jaxoDraw(g2, true);
        }
        for (i = 0; i < actCanGraph.listSize(); ++i) {
            jaxoOb = actCanGraph.listElementAt(i);
            Plot.drawRest(jaxoOb, g2, true);
        }
        g2.dispose();
        actCan.repaint();
    }

    public final void setFlagPanelCoordinates(String coordinates) {
        this.flagpanel.setCoordFlagText(coordinates);
    }

    public final void setFlagPanelMode(String mode) {
        this.flagpanel.setControlFlagText(mode);
    }

    public final void setFlagPanelFileName(String filename) {
        this.flagpanel.setFileFlagText(filename);
    }

    public final void setLanguage(String languageString) {
        JaxoPrefs.setPref(4, languageString);
        this.filemenu.setLanguage(languageString);
        this.editmenu.setLanguage(languageString);
        this.optionsmenu.setLanguage(languageString);
        this.helpmenu.setLanguage(languageString);
        this.toolbar.setLanguage(languageString);
        this.pbtpanel.setLanguage(languageString);
        this.mbtpanel.setLanguage(languageString);
        this.abtpanel.setLanguage(languageString);
        this.ebtpanel.setLanguage(languageString);
        this.flagpanel.setLanguage(languageString);
        this.canvasPanel.setLanguage(languageString);
    }

    public final void particleEvent(int i) {
        JaxoCanvas theCanvas = this.getCanvas();
        this.resetButtons();
        int j = this.pbtpanel.getIndex(i);
        this.pbtpanel.pressButton(j);
        this.flagpanel.setControlFlagText(this.pbtpanel.getParticleFlagModes(j));
        this.setMode(i);
        theCanvas.getCanvasGraph().setSelectedObject(null);
        theCanvas.drawWithHandles(false);
        theCanvas.drawVisualAid(false);
        theCanvas.repaint();
    }

    public final void miscEvent(int i) {
        JaxoCanvas theCanvas = this.getCanvas();
        this.resetButtons();
        int j = this.mbtpanel.getIndex(i);
        this.mbtpanel.pressButton(j);
        this.flagpanel.setControlFlagText(this.mbtpanel.getMiscFlagModes(j));
        this.setMode(i);
        theCanvas.getCanvasGraph().setSelectedObject(null);
        theCanvas.drawWithHandles(false);
        theCanvas.drawVisualAid(false);
        theCanvas.repaint();
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void setAxes(int n1, int n2) {
        this.japlot.clearAllData();
        this.japlot.clearAll();
        this.japlot.setAxesFrame(n1, n2);
        this.japlot.update();
    }

    public final void editEvent(int i) {
        JaxoCanvas theCanvas = this.getCanvas();
        this.resetButtons();
        int j = 0;
        j = this.ebtpanel.getIndex(i);
        this.ebtpanel.pressButton(j);
        this.flagpanel.setControlFlagText(this.ebtpanel.getEditFlagModes(j));
        this.setMode(i);
        theCanvas.getCanvasGraph().setSelectedObject(null);
        if (this.getMode() == 59) {
            theCanvas.drawWithHandles(false);
        } else {
            theCanvas.drawWithHandles(true);
        }
        if (this.getMode() == 47) {
            this.updateZoom();
        }
        theCanvas.drawVisualAid(false);
        theCanvas.repaint();
    }

    public final void fileEvent(int i) {
        switch (i) {
            case 70: {
                this.filemenu.aNewG();
                break;
            }
            case 80: {
                this.filemenu.aNewT();
                break;
            }
            case 71: {
                this.filemenu.open();
                break;
            }
            case 82: {
                this.filemenu.opendata();
                break;
            }
            case 81: {
                this.filemenu.importLatex();
                break;
            }
            case 78: {
                this.filemenu.close();
                break;
            }
            case 72: {
                this.filemenu.save();
                break;
            }
            case 73: {
                this.filemenu.saveAs();
                break;
            }
            case 75: {
                this.filemenu.export();
                break;
            }
            case 76: {
                this.filemenu.print();
                break;
            }
            case 44: {
                this.filemenu.quit();
                break;
            }
            case 46: {
                this.actionEvent(46);
                break;
            }
            case 77: {
                JaxoCanvas theCanvas = this.getCanvas();
                Dimension d = new Dimension(theCanvas.getWidth(), theCanvas.getHeight());
                JaxoPreview preLatex = new JaxoPreview();
                preLatex.previewLatexPS(theCanvas.getCanvasGraph(), d, this.isWatchMode());
                this.actionEvent(45);
                break;
            }
        }
    }

    public void helpEvent() {
        new HelpDialog((Component)this, "japlot.html");
    }

    public final void actionEvent(int i) {
        JaxoCanvas theCanvas = this.getCanvas();
        JaxoGraph theGraph = theCanvas.getCanvasGraph();
        this.resetButtons();
        switch (i) {
            case 42: {
                theGraph.undo();
                theCanvas.swapImages();
                this.updateZoom();
                if (this.isEditMode()) {
                    this.ebtpanel.pressButton(this.ebtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(true);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                } else if (this.isParticleMode()) {
                    this.pbtpanel.pressButton(this.pbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                } else if (this.isMiscMode()) {
                    this.mbtpanel.pressButton(this.mbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                }
                for (int j = 0; j < theGraph.listSize(); ++j) {
                    JaObject jaxoOb = theGraph.listElementAt(j);
                    if (!(jaxoOb instanceof JaLatexText)) continue;
                    ((JaLatexText)jaxoOb).createLatexPanel();
                    theCanvas.add(((JaLatexText)jaxoOb).getLatexPanel());
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
                }
                theGraph.setSelectedObject(null);
                break;
            }
            case 43: {
                theCanvas.saveBackupImage();
                theGraph.backup();
                theGraph.clear();
                if (this.isEditMode()) {
                    this.ebtpanel.pressButton(this.ebtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(true);
                    theCanvas.drawVisualAid(false);
                } else if (this.isParticleMode()) {
                    this.pbtpanel.pressButton(this.pbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                } else if (this.isMiscMode()) {
                    this.mbtpanel.pressButton(this.mbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                }
                theGraph.setSelectedObject(null);
                theCanvas.clearOffScreenImage();
                theCanvas.repaint();
                break;
            }
            case 46: {
                theCanvas.saveBackupImage();
                theGraph.backup();
                for (int k = 0; k < this.clipboard.listSize(); ++k) {
                    theGraph.addObject(this.clipboard.listElementAt(k).copy());
                }
                for (int j = 0; j < theGraph.listSize(); ++j) {
                    JaObject jaxoOb = theGraph.listElementAt(j);
                    if (!(jaxoOb instanceof JaLatexText)) continue;
                    ((JaLatexText)jaxoOb).createLatexPanel();
                    theCanvas.add(((JaLatexText)jaxoOb).getLatexPanel());
                    ((JaLatexText)jaxoOb).getLatexPanel().setVisible(false);
                }
                theCanvas.setOldbb(this.clipboard.getBoundingBox());
                theCanvas.updateOffScreenImage();
                this.editEvent(50);
                theCanvas.unsavedCanvas();
                this.actionEvent(45);
                break;
            }
            case 45: {
                theCanvas.setOldbb(theGraph.getBoundingBox());
                theCanvas.updateOffScreenImage();
                if (this.isEditMode()) {
                    this.ebtpanel.pressButton(this.ebtpanel.getIndex(this.currentMode));
                    if (this.ebtpanel.getIndex(this.currentMode) == 9) {
                        theCanvas.drawWithHandles(false);
                    } else {
                        theCanvas.drawWithHandles(true);
                    }
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                } else if (this.isParticleMode()) {
                    this.pbtpanel.pressButton(this.pbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                } else if (this.isMiscMode()) {
                    this.mbtpanel.pressButton(this.mbtpanel.getIndex(this.currentMode));
                    theCanvas.drawWithHandles(false);
                    theCanvas.drawVisualAid(false);
                    this.repaint();
                }
                theGraph.setSelectedObject(null);
                break;
            }
        }
    }

    public void clearData(int padX, int padY) {
        this.japlot.clearData(padX, padY);
    }

    public void update() {
        JaxoCanvas theCanvas = this.getCanvas();
        if (theCanvas == null) {
            return;
        }
        JaxoGraph theGraph = theCanvas.getCanvasGraph();
        if (theGraph == null) {
            return;
        }
        this.resetButtons();
        this.getCanvas().update();
        theCanvas.setOldbb(theGraph.getBoundingBox());
        theCanvas.updateOffScreenImage();
        if (this.isEditMode()) {
            this.ebtpanel.pressButton(this.ebtpanel.getIndex(this.currentMode));
            if (this.ebtpanel.getIndex(this.currentMode) == 9) {
                theCanvas.drawWithHandles(false);
            } else {
                theCanvas.drawWithHandles(true);
            }
            theCanvas.drawVisualAid(false);
            this.repaint();
        } else if (this.isParticleMode()) {
            this.pbtpanel.pressButton(this.pbtpanel.getIndex(this.currentMode));
            theCanvas.drawWithHandles(false);
            theCanvas.drawVisualAid(false);
            this.repaint();
        } else if (this.isMiscMode()) {
            this.mbtpanel.pressButton(this.mbtpanel.getIndex(this.currentMode));
            theCanvas.drawWithHandles(false);
            theCanvas.drawVisualAid(false);
            this.repaint();
        }
        theGraph.setSelectedObject(null);
    }

    public final void resetButtons() {
        this.mbtpanel.reset();
        this.pbtpanel.reset();
        this.ebtpanel.reset();
    }

    public final void repaintCanvas() {
        this.getCanvas().repaint();
    }

    public int getSizeX() {
        Dimension d = this.getCanvas().getSize();
        return (int)d.getWidth();
    }

    public int getSizeY() {
        Dimension d = this.getCanvas().getSize();
        return (int)d.getHeight();
    }

    public JaxoGraph getGraph() {
        return this.getCanvas().getCanvasGraph();
    }

    public void shutdown() {
        this.getCanvas().dispose();
        this.japlot.clearAllData();
        this.japlot.clearAll();
        this.setVisible(false);
        this.clipboard = null;
        this.mbtpanel = null;
        this.abtpanel = null;
        this.editmenu = null;
        this.helpmenu = null;
        this.optionsmenu = null;
        this.flagpanel = null;
        System.gc();
        this.dispose();
    }

    public void setSizeCanvas(int xsize, int ysize) {
        Dimension d = new Dimension(xsize, ysize);
        JaxoCanvas theCanvas = this.getCanvas();
        theCanvas.setSize(d);
        SwingUtilities.updateComponentTreeUI(this);
        theCanvas.repaint();
    }

    public final void applyPrefs() {
        JaxoCanvas theCanvas = this.getCanvas();
        this.optionsmenu.showStatusbar(JaxoPrefs.getBooleanPref(301));
        this.optionsmenu.showToolbar(JaxoPrefs.getBooleanPref(300));
        this.optionsmenu.showEditorbar(JaxoPrefs.getBooleanPref(305));
        this.optionsmenu.antialiasOn(JaxoPrefs.getBooleanPref(302));
        this.optionsmenu.arrow(JaxoPrefs.getBooleanPref(303));
        this.optionsmenu.setDefault(JaxoPrefs.getIntPref(114));
        theCanvas.setSize(JaxoPrefs.getIntPref(100), JaxoPrefs.getIntPref(101));
        this.zoom.setZoomFactor(JaxoPrefs.getIntPref(110));
        this.zoom.setZoomWindowWidth(JaxoPrefs.getIntPref(111));
        this.zoom.setZoomWindowHeight(JaxoPrefs.getIntPref(112));
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        int num = info.length;
        String[] humanReadableName = new String[num];
        String[] className = new String[num];
        String newLAF = info[0].getClassName();
        String newLAFname = info[0].getName();
        for (int i = 0; i < num; ++i) {
            humanReadableName[i] = info[i].getName();
            className[i] = info[i].getClassName();
            String prefLOOKNFEEL = JaxoPrefs.getStringPref(3);
            if (!prefLOOKNFEEL.equals(humanReadableName[i])) continue;
            newLAF = className[i];
            newLAFname = humanReadableName[i];
        }
        try {
            UIManager.setLookAndFeel(newLAF);
        }
        catch (Exception exc) {
            if (JaxoPrefs.verbose()) {
                System.err.println(exc);
            }
            JOptionPane.showMessageDialog(null, newLAFname + this.language.getString("_Look_and_Feel_is_not_supported_on_this_platform!"));
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.setLanguage(JaxoPrefs.getPref(4));
        theCanvas.repaint();
    }

    public final void showToolbar(boolean show) {
        this.toolbar.setVisible(show);
        JaxoPrefs.setBooleanPref(300, show);
    }

    public final void showEditorbar(boolean show) {
        this.jToolBar.setVisible(show);
        JaxoPrefs.setBooleanPref(305, show);
    }

    public final void showBrowserbar(boolean show) {
        JaxoPrefs.setBooleanPref(306, show);
    }

    public final void showStatusbar(boolean show) {
        this.flagpanel.setVisible(show);
        JaxoPrefs.setBooleanPref(301, show);
    }

    public final void antialiasOn(boolean on) {
        JaxoCanvas theCanvas = this.getCanvas();
        JaxoPrefs.setBooleanPref(302, on);
        if (theCanvas.getOffScreenImage() != null) {
            theCanvas.setOldbb(theCanvas.getCanvasGraph().getBoundingBox());
            theCanvas.updateOffScreenImage();
        }
    }

    public final void gridOn(boolean on) {
    }

    public final void arrow(boolean on) {
        JaxoCanvas theCanvas = this.getCanvas();
        JaxoPrefs.setBooleanPref(303, on);
        if (theCanvas.getOffScreenImage() != null) {
            theCanvas.setOldbb(theCanvas.getCanvasGraph().getBoundingBox());
            theCanvas.updateOffScreenImage();
        }
    }

    public final void setVertexType(int type) {
        this.currentVertex = type;
    }

    public final int getVertexType() {
        return this.currentVertex;
    }

    public final void setClipboard(JaxoGraph newClipboard) {
        this.clipboard = newClipboard;
    }

    public final JaxoGraph getClipboard() {
        return this.clipboard;
    }

    public final void setSnap(boolean newSnap) {
        this.snap = newSnap;
    }

    public final boolean getSnap() {
        return this.snap;
    }

    public final boolean isWatchMode() {
        return this.watchMode;
    }

    public final void setWatchMode(boolean choice) {
        this.watchMode = choice;
    }

    public final JaxoParticleButtons getPbtPanel() {
        return this.pbtpanel;
    }

    public final JaxoEditButtons getEbtPanel() {
        return this.ebtpanel;
    }

    public final JaxoMiscButtons getMbtPanel() {
        return this.mbtpanel;
    }

    public final JaxoGridButtons getGbtPanel() {
        return this.gbtpanel;
    }

    public final JaxoTabbedCanvasPanel getCanvasPanel() {
        return this.canvasPanel;
    }

    public final JaxoOptionsMenu getOptMenu() {
        return this.optionsmenu;
    }

    public final void setZoom(JaxoZoom z) {
        this.zoom = z;
    }

    public final JaxoZoom getZoom() {
        return this.zoom;
    }

    public final void updateZoom() {
        JaxoCanvas theCanvas = this.getCanvas();
        this.zoom.setBackground(theCanvas.getOffScreenImage());
        this.zoom.setGraphics(theCanvas.getGraphics());
        this.zoom.setImageWidth(theCanvas.getOffScreenImage().getWidth(null));
        this.zoom.setImageHeight(theCanvas.getOffScreenImage().getHeight(null));
        this.zoom.setCanvasWidth(theCanvas.getWidth());
        this.zoom.setCanvasHeight(theCanvas.getHeight());
        this.zoom.setTmpImage();
    }

    public final void fillBrowser(Map<String, Object> map) {
        int N1 = this.getJaPlot().getNtotX();
        int N2 = this.getJaPlot().getNtotY();
        if (N1 == 0 || N2 == 0) {
            JOptionPane.showMessageDialog(this, "Warning!  You cannot plot objects using the mouse before creating drawing pad. \n Press exit \"ObjectBrowser\" and create pads using the menu \"Option - Add Pads\"\n", "JaBrowser warning", 2);
        }
        BrowserDataGeneric jabrowser = new BrowserDataGeneric();
        jabrowser.setDataFileBrowser(this, map, true);
    }

    public void exportImage() {
        String tab = this.getCanvasPanel().getSelectedComponent().getName();
        JaxoExportPanel e = new JaxoExportPanel();
        e.setCurrentTab(tab);
        ExportVGraphics.exportDialog(this.getCanvas(), JaxoMainPanel.class.getName(), this);
    }

    public void export(String file) {
        String currentTab = this.getCanvasPanel().getSelectedComponent().getName();
        JaxoGraph graph = this.getCanvas().getCanvasGraph();
        Component cc = this.getCanvasPanel().getSelectedComponent();
        cc.validate();
        ExportVGraphics.export(cc, rootKey, file);
    }
}

