/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.util.ResourceBundle;

public final class JaxoColor {
    public static final Color GREEN_YELLOW = new Color(214, 232, 15);
    public static final Color YELLOW = new Color(249, 229, 38);
    public static final Color GOLDEN_ROD = new Color(249, 214, 22);
    public static final Color DANDELION = new Color(255, 198, 30);
    public static final Color APRICOT = new Color(252, 165, 119);
    public static final Color PEACH = new Color(252, 127, 63);
    public static final Color MELON = new Color(249, 130, 127);
    public static final Color YELLOW_ORANGE = new Color(234, 175, 15);
    public static final Color ORANGE = new Color(221, 79, 5);
    public static final Color BURNT_ORANGE = new Color(221, 117, 0);
    public static final Color BITTERSWEET = new Color(188, 79, 7);
    public static final Color RED_ORANGE = new Color(226, 61, 40);
    public static final Color MAHOGANY = new Color(155, 48, 28);
    public static final Color MAROON = new Color(163, 38, 56);
    public static final Color BRICK_RED = new Color(175, 38, 38);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color ORANGE_RED = new Color(206, 0, 124);
    public static final Color RUBINE_RED = new Color(204, 0, 160);
    public static final Color WILDSTRAWBERRY = new Color(211, 5, 71);
    public static final Color SALMON = new Color(252, 140, 153);
    public static final Color CARNATION_PINK = new Color(237, 114, 170);
    public static final Color MAGENTA = new Color(219, 40, 165);
    public static final Color VIOLET_RED = new Color(226, 40, 130);
    public static final Color RHODAMINE = new Color(234, 107, 191);
    public static final Color MULBERRY = new Color(173, 0, 117);
    public static final Color RED_VIOLET = new Color(170, 0, 102);
    public static final Color FUCHSIA = new Color(163, 5, 127);
    public static final Color LAVENDER = new Color(249, 147, 196);
    public static final Color THISTLE = new Color(232, 127, 201);
    public static final Color ORCHID = new Color(211, 107, 198);
    public static final Color DARK_ORCHID = new Color(142, 71, 173);
    public static final Color PURPLE = new Color(137, 79, 191);
    public static final Color PLUM = new Color(81, 45, 68);
    public static final Color VIOLET = new Color(48, 68, 181);
    public static final Color ROYAL_PURPLE = new Color(89, 17, 142);
    public static final Color BLUE_VIOLET = new Color(53, 0, 109);
    public static final Color PERIWINKLE = new Color(147, 122, 204);
    public static final Color CADET_BLUE = new Color(94, 104, 196);
    public static final Color CORNFLOWER_BLUE = new Color(117, 178, 221);
    public static final Color MIDNIGHT_BLUE = new Color(0, 79, 109);
    public static final Color NAVY_BLUE = new Color(0, 81, 186);
    public static final Color ROYAL_BLUE = new Color(0, 132, 201);
    public static final Color BLUE = new Color(0, 56, 168);
    public static final Color CERULEAN = new Color(0, 198, 178);
    public static final Color CYAN = new Color(94, 221, 193);
    public static final Color PROCESS_BLUE = new Color(71, 214, 193);
    public static final Color SKY_BLUE = new Color(81, 191, 226);
    public static final Color TURQUOISE = new Color(0, 183, 198);
    public static final Color TEAL_BLUE = new Color(0, 132, 142);
    public static final Color AQUAMARINE = new Color(0, 155, 170);
    public static final Color BLUE_GREEN = new Color(0, 158, 160);
    public static final Color EMERALD = new Color(0, 183, 96);
    public static final Color JUNGLE_GREEN = new Color(0, 119, 112);
    public static final Color SEA_GREEN = new Color(0, 175, 153);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color FOREST_GREEN = new Color(0, 107, 63);
    public static final Color PINE_GREEN = new Color(0, 102, 99);
    public static final Color LIME_GREEN = new Color(140, 214, 0);
    public static final Color YELLOW_GREEN = new Color(127, 186, 0);
    public static final Color SPRING_GREEN = new Color(204, 226, 38);
    public static final Color OLIVE_GREEN = new Color(135, 137, 5);
    public static final Color RAWSIENNA = new Color(153, 89, 5);
    public static final Color SEPIA = new Color(99, 58, 17);
    public static final Color BROWN = new Color(132, 63, 15);
    public static final Color TAN = new Color(249, 114, 66);
    public static final Color GRAY = new Color(102, 109, 112);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color GRAYSCALE15 = new Color(15, 15, 15);
    public static final Color GRAYSCALE30 = new Color(30, 30, 30);
    public static final Color GRAYSCALE45 = new Color(45, 45, 45);
    public static final Color GRAYSCALE60 = new Color(60, 60, 60);
    public static final Color GRAYSCALE75 = new Color(75, 75, 75);
    public static final Color GRAYSCALE90 = new Color(90, 90, 90);
    public static final Color GRAYSCALE105 = new Color(105, 105, 105);
    public static final Color GRAYSCALE120 = new Color(120, 120, 120);
    public static final Color GRAYSCALE135 = new Color(135, 135, 135);
    public static final Color GRAYSCALE150 = new Color(150, 150, 150);
    public static final Color GRAYSCALE165 = new Color(165, 165, 165);
    public static final Color GRAYSCALE180 = new Color(180, 180, 180);
    public static final Color GRAYSCALE195 = new Color(195, 195, 195);
    public static final Color GRAYSCALE210 = new Color(210, 210, 210);
    public static final Color GRAYSCALE225 = new Color(225, 225, 225);
    public static final Color GRAYSCALE240 = new Color(240, 240, 240);
    public static final Color WHITE = new Color(255, 255, 255);
    private static Color[] colorList = new Color[]{GREEN_YELLOW, YELLOW, GOLDEN_ROD, DANDELION, APRICOT, PEACH, MELON, YELLOW_ORANGE, ORANGE, BURNT_ORANGE, BITTERSWEET, RED_ORANGE, MAHOGANY, MAROON, BRICK_RED, RED, ORANGE_RED, RUBINE_RED, WILDSTRAWBERRY, SALMON, CARNATION_PINK, MAGENTA, VIOLET_RED, RHODAMINE, MULBERRY, RED_VIOLET, FUCHSIA, LAVENDER, THISTLE, ORCHID, DARK_ORCHID, PURPLE, PLUM, VIOLET, ROYAL_PURPLE, BLUE_VIOLET, PERIWINKLE, CADET_BLUE, CORNFLOWER_BLUE, MIDNIGHT_BLUE, NAVY_BLUE, ROYAL_BLUE, BLUE, CERULEAN, CYAN, PROCESS_BLUE, SKY_BLUE, TURQUOISE, TEAL_BLUE, AQUAMARINE, BLUE_GREEN, EMERALD, JUNGLE_GREEN, SEA_GREEN, GREEN, FOREST_GREEN, PINE_GREEN, LIME_GREEN, YELLOW_GREEN, SPRING_GREEN, OLIVE_GREEN, RAWSIENNA, SEPIA, BROWN, TAN, GRAY, BLACK, GRAYSCALE15, GRAYSCALE30, GRAYSCALE45, GRAYSCALE60, GRAYSCALE75, GRAYSCALE90, GRAYSCALE105, GRAYSCALE120, GRAYSCALE135, GRAYSCALE150, GRAYSCALE165, GRAYSCALE180, GRAYSCALE195, GRAYSCALE210, GRAYSCALE225, GRAYSCALE240, WHITE};
    private static int nofColors = colorList.length;
    private static String[] colorName = new String[]{"GreenYellow", "Yellow", "Goldenrod", "Dandelion", "Apricot", "Peach", "Melon", "YellowOrange", "Orange", "BurntOrange", "Bittersweet", "RedOrange", "Mahogany", "Maroon", "BrickRed", "Red", "OrangeRed", "RubineRed", "WildStrawberry", "Salmon", "CarnationPink", "Magenta", "VioletRed", "Rhodamine", "Mulberry", "RedViolet", "Fuchsia", "Lavender", "Thistle", "Orchid", "DarkOrchid", "Purple", "Plum", "Violet", "RoyalPurple", "BlueViolet", "Periwinkle", "CadetBlue", "CornflowerBlue", "MidnightBlue", "NavyBlue", "RoyalBlue", "Blue", "Cerulean", "Cyan", "ProcessBlue", "SkyBlue", "Turquoise", "TealBlue", "Aquamarine", "BlueGreen", "Emerald", "JungleGreen", "SeaGreen", "Green", "ForestGreen", "PineGreen", "LimeGreen", "YellowGreen", "SpringGreen", "OliveGreen", "RawSienna", "Sepia", "Brown", "Tan", "Gray", "Black", "GrayScale15", "GrayScale30", "GrayScale45", "GrayScale60", "GrayScale75", "GrayScale90", "GrayScale105", "GrayScale120", "GrayScale135", "GrayScale150", "GrayScale165", "GrayScale180", "GrayScale195", "GrayScale210", "GrayScale225", "GrayScale240", "White"};

    private JaxoColor() {
    }

    public static Color getColor(int i) {
        return colorList[i];
    }

    public static Color getColor(String cName) {
        int i = 0;
        boolean notinthelist = false;
        while (colorName[i].compareTo(cName) != 0) {
            if (++i < JaxoColor.getNofColors()) continue;
            notinthelist = true;
            break;
        }
        if (notinthelist) {
            return colorList[JaxoColor.getIndex(BLACK)];
        }
        return colorList[i];
    }

    public static String getColorName(int i) {
        return colorName[i];
    }

    public static String getColorName(Color color) {
        int i = 0;
        while (!colorList[i].equals(color)) {
            ++i;
        }
        return colorName[i];
    }

    public static int getNofColors() {
        return nofColors;
    }

    public static int getIndex(Color color) {
        int i = 0;
        while (!colorList[i].equals(color)) {
            ++i;
        }
        return i;
    }

    public static int getIndex(String cName) {
        int i = 0;
        while (colorName[i].compareTo(cName) != 0) {
            ++i;
        }
        return i;
    }

    public static String getGreyScale(Color color) {
        String greyScale = "";
        int i = 0;
        while (!colorList[i].equals(color)) {
            ++i;
        }
        if (i >= JaxoColor.getIndex(BLACK)) {
            int r = color.getRed();
            float frac = (float)((int)(1000.0f * (float)r / 255.0f)) / 1000.0f;
            greyScale = Float.toString(frac);
        } else {
            greyScale = ResourceBundle.getBundle(JaxoPrefs.getPref(4)).getString("not_a_Greyscale!");
        }
        return greyScale;
    }

    public static boolean isGrayScale(Color color) {
        boolean itis = false;
        int i = 0;
        while (!colorList[i].equals(color)) {
            ++i;
        }
        if (i >= JaxoColor.getIndex(BLACK) && i != JaxoColor.getIndex(WHITE)) {
            itis = true;
        }
        return itis;
    }

    public static String getLatexColorCommand(Color color) {
        String base = "\\SetColor{";
        String closing = "}";
        String thisColor = "";
        int i = 0;
        while (!colorList[i].equals(color)) {
            ++i;
        }
        thisColor = i > JaxoColor.getIndex(BLACK) && i != JaxoColor.getIndex(WHITE) ? "Black" : colorName[i];
        String latexColor = base.concat(thisColor.concat(closing));
        return latexColor;
    }

    public static Color getGrayScale(float f) {
        Color grayScale = null;
        if (f >= 0.0f && f <= 1.0f) {
            int offset = Math.round(17.0f * f);
            grayScale = colorList[JaxoColor.getIndex(BLACK) + offset];
        }
        return grayScale;
    }
}

