/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoColorChooser;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jhplot.jadraw.JaArcObject;
import jhplot.jadraw.JaFArc;
import jhplot.jadraw.JaGArc;
import jhplot.jadraw.JaGlArc;
import jhplot.jadraw.JaPArc;
import jhplot.jadraw.JaSArc;

public class JaxoArcOptionsPanel
extends JPanel
implements ItemListener,
ActionListener {
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private JaArcObject theArc;
    private String theParticle;
    private Icon theIcon;
    private ImageIcon colorPreviewIcon;
    private Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private SpinnerNumberModel modelampin;
    private SpinnerNumberModel modelwigin;
    private JButton colorbt;
    private JPanel colorPanel;
    private TitledBorder colorPanelTitle;
    private JCheckBox arrowcb;
    private JCheckBox flipcb;
    private JPanel arcArrowPanel;
    private TitledBorder arcArrowTitle;
    private Color newColor;
    private Image colorPreview;
    private boolean newFlip;
    private boolean newArrow;
    private boolean newEnd;
    private int newAmp;
    private float newFreq;
    private int newWiggles;
    private float newStroke;
    private float newDash;
    private boolean changed = false;
    private boolean newDLine;
    private float newDLSep;
    private JCheckBox dlcb;
    private JLabel stsep;
    private JSpinner spsep;
    private int nx1;
    private int nx2;
    private int nx3;
    private int ny1;
    private int ny2;
    private int ny3;
    private JRadioButton middlerb;
    private JRadioButton endrb;
    private JPanel arcMiddlePanel;
    private TitledBorder arcMiddleTitle;

    public JaxoArcOptionsPanel(JaArcObject newArc) {
        this.theArc = newArc;
        this.nx1 = Math.round(this.theArc.getX1());
        this.ny1 = Math.round(this.theArc.getY1());
        this.nx2 = Math.round(this.theArc.getX2());
        this.ny2 = Math.round(this.theArc.getY2());
        this.nx3 = this.theArc.getX();
        this.ny3 = this.theArc.getY();
        double[] pars = this.theArc.getArcParameters();
        this.newColor = this.theArc.getColor();
        this.colorPreview = this.getChooserImage(this.newColor);
        this.colorPreviewIcon = new ImageIcon(this.colorPreview);
        this.newArrow = this.theArc.getArrow();
        this.newFlip = this.theArc.getFlip();
        this.newEnd = this.theArc.getEnd();
        this.newAmp = this.theArc.getAmp();
        this.newStroke = this.theArc.getStroke();
        this.newDash = this.theArc.getDash();
        this.newFreq = this.theArc.getFreq();
        this.newDLine = this.theArc.getDoubleLine();
        this.newDLSep = this.theArc.getDLSeparation();
        if ((double)this.newDLSep < 0.5) {
            this.newDLSep = JaxoPrefs.getFloatPref(201);
        }
        if (this.theArc instanceof JaFArc) {
            this.theParticle = this.language.getString("Fermion_arc_parameters");
            this.theIcon = new ImageIcon(JaxoArcOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/farc.gif"));
        } else if (this.theArc instanceof JaSArc) {
            this.theParticle = this.language.getString("Scalar_arc_parameters");
            this.theIcon = new ImageIcon(JaxoArcOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/sarc.gif"));
        } else if (this.theArc instanceof JaGArc) {
            this.theParticle = this.language.getString("Ghost_arc_parameters");
            this.theIcon = new ImageIcon(JaxoArcOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/garc.gif"));
        } else if (this.theArc instanceof JaPArc) {
            this.theParticle = this.language.getString("Photon_arc_parameters");
            this.theIcon = new ImageIcon(JaxoArcOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/photonarc.gif"));
            this.newWiggles = (int)Math.round(pars[2] * 2.0 * Math.abs(pars[3] / 2.0) / (double)this.newFreq);
        } else if (this.theArc instanceof JaGlArc) {
            this.theParticle = this.language.getString("Gluon_arc_parameters");
            this.theIcon = new ImageIcon(JaxoArcOptionsPanel.class.getClassLoader().getResource("japlot/jaxodraw/icons/gluonarc.gif"));
            this.newWiggles = (int)Math.round((pars[2] * 2.0 * Math.abs(pars[3] / 2.0) - (double)this.newFreq) / (double)this.newFreq / (double)0.6f);
        }
        JPanel px1 = new JPanel();
        px1.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX1 = new SpinnerNumberModel(this.nx1, 0, this.d.width, 1);
        JLabel lx1 = new JLabel("X1: ", 4);
        px1.add(lx1);
        JSpinner spx1 = new JSpinner(modelX1);
        px1.add(spx1);
        JPanel px2 = new JPanel();
        px2.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX2 = new SpinnerNumberModel(this.nx2, 0, this.d.width, 1);
        JLabel lx2 = new JLabel("X2: ", 4);
        px2.add(lx2);
        JSpinner spx2 = new JSpinner(modelX2);
        px2.add(spx2);
        JPanel px3 = new JPanel();
        px3.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelX3 = new SpinnerNumberModel(this.nx3, 0, this.d.width, 1);
        JLabel lx3 = new JLabel("X3: ", 4);
        px3.add(lx3);
        JSpinner spx3 = new JSpinner(modelX3);
        px3.add(spx3);
        JPanel py1 = new JPanel();
        py1.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY1 = new SpinnerNumberModel(this.ny1, 0, this.d.height, 1);
        JLabel ly1 = new JLabel("Y1: ", 4);
        py1.add(ly1);
        JSpinner spy1 = new JSpinner(modelY1);
        py1.add(spy1);
        JPanel py2 = new JPanel();
        py2.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY2 = new SpinnerNumberModel(this.ny2, 0, this.d.height, 1);
        JLabel ly2 = new JLabel("Y2: ", 4);
        py2.add(ly2);
        JSpinner spy2 = new JSpinner(modelY2);
        py2.add(spy2);
        JPanel py3 = new JPanel();
        py3.setLayout(new GridLayout(0, 2));
        SpinnerNumberModel modelY3 = new SpinnerNumberModel(this.ny3, 0, this.d.height, 1);
        JLabel ly3 = new JLabel("Y3: ", 4);
        py3.add(ly3);
        JSpinner spy3 = new JSpinner(modelY3);
        py3.add(spy3);
        JPanel dimSPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        dimSPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        px1.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px1, sc);
        dimSPanel.add((Component)px1, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py1.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py1, sc);
        dimSPanel.add((Component)py1, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        px2.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px2, sc);
        dimSPanel.add((Component)px2, sc);
        sc.gridx = 1;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py2.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py2, sc);
        dimSPanel.add((Component)py2, sc);
        sc.gridx = 2;
        sc.gridy = 0;
        px3.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(px3, sc);
        dimSPanel.add((Component)px3, sc);
        sc.gridx = 2;
        sc.gridy = 1;
        sc.insets = new Insets(3, 0, 3, 0);
        py3.setPreferredSize(new Dimension(120, 20));
        gb.setConstraints(py3, sc);
        dimSPanel.add((Component)py3, sc);
        JPanel finalDimSPanel = new JPanel();
        finalDimSPanel.setLayout(new BoxLayout(finalDimSPanel, 0));
        TitledBorder dimSTitle = BorderFactory.createTitledBorder(this.language.getString("Points_coordinates"));
        finalDimSPanel.setBorder(dimSTitle);
        finalDimSPanel.add(dimSPanel);
        JPanel pstin = new JPanel();
        GridBagLayout subgb = new GridBagLayout();
        GridBagConstraints subc = new GridBagConstraints();
        pstin.setLayout(subgb);
        SpinnerNumberModel modelstin = new SpinnerNumberModel(this.newStroke, 0.0, 100.0, 0.2);
        JLabel stin = new JLabel(this.language.getString("Line_Width"), 4);
        JSpinner spstin = new JSpinner(modelstin);
        subc.gridx = 0;
        subc.gridy = 0;
        subc.insets = new Insets(0, 5, 0, 5);
        subgb.setConstraints(stin, subc);
        pstin.add((Component)stin, subc);
        subc.gridx = 1;
        subc.gridy = 0;
        spstin.setPreferredSize(new Dimension(50, 20));
        subgb.setConstraints(spstin, subc);
        pstin.add((Component)spstin, subc);
        JPanel pdsin = new JPanel();
        GridBagLayout subgb1 = new GridBagLayout();
        GridBagConstraints subc1 = new GridBagConstraints();
        pdsin.setLayout(subgb);
        SpinnerNumberModel modeldsin = new SpinnerNumberModel(this.newDash, 0.0, 50.0, 0.2);
        JLabel dsin = new JLabel(" " + this.language.getString("Dash_Size"), 4);
        pdsin.add(dsin);
        JSpinner spdsin = new JSpinner(modeldsin);
        subc1.gridx = 0;
        subc1.gridy = 0;
        subc1.insets = new Insets(0, 5, 5, 5);
        subgb1.setConstraints(dsin, subc1);
        pdsin.add((Component)dsin, subc1);
        subc1.gridx = 1;
        subc1.gridy = 0;
        spdsin.setPreferredSize(new Dimension(50, 20));
        subgb1.setConstraints(spdsin, subc1);
        pdsin.add((Component)spdsin, subc1);
        if (this.theArc instanceof JaFArc || this.theArc instanceof JaPArc || this.theArc instanceof JaGlArc) {
            dsin.setEnabled(false);
            spdsin.setEnabled(false);
        }
        JPanel strSPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        GridBagConstraints sc1 = new GridBagConstraints();
        strSPanel.setLayout(gb1);
        sc1.gridx = 0;
        sc1.gridy = 0;
        gb1.setConstraints(pstin, sc1);
        strSPanel.add((Component)pstin, sc1);
        sc1.gridx = 0;
        sc1.gridy = 1;
        sc1.insets = new Insets(5, 0, 0, 0);
        gb1.setConstraints(pdsin, sc1);
        strSPanel.add((Component)pdsin, sc1);
        JPanel finalStrSPanel = new JPanel();
        finalStrSPanel.setLayout(new BoxLayout(finalStrSPanel, 0));
        TitledBorder strSTitle = BorderFactory.createTitledBorder(this.language.getString("Width/Dashing"));
        finalStrSPanel.setBorder(strSTitle);
        finalStrSPanel.add(strSPanel);
        this.colorbt = new JButton(this.colorPreviewIcon);
        this.colorbt.addActionListener(this);
        this.colorPanel = new JPanel();
        this.colorPanelTitle = BorderFactory.createTitledBorder(this.language.getString("Color"));
        this.colorPanel.setBorder(this.colorPanelTitle);
        this.colorPanel.add(this.colorbt);
        JPanel finalAwSPanel = new JPanel();
        if (this.theArc instanceof JaPArc || this.theArc instanceof JaGlArc) {
            JPanel pampin = new JPanel();
            GridBagLayout subgb2 = new GridBagLayout();
            GridBagConstraints subc2 = new GridBagConstraints();
            pampin.setLayout(subgb2);
            this.modelampin = new SpinnerNumberModel((double)this.newAmp, -500.0, 500.0, 1.0);
            JLabel ampin = new JLabel(this.language.getString("Amplitude"), 4);
            JSpinner spampin = new JSpinner(this.modelampin);
            subc2.gridx = 0;
            subc2.gridy = 0;
            subgb2.setConstraints(ampin, subc2);
            pampin.add((Component)ampin, subc2);
            subc2.gridx = 1;
            subc2.gridy = 0;
            spampin.setPreferredSize(new Dimension(60, 20));
            subgb2.setConstraints(spampin, subc2);
            pampin.add((Component)spampin, subc2);
            JPanel pwigin = new JPanel();
            GridBagLayout subgb3 = new GridBagLayout();
            GridBagConstraints subc3 = new GridBagConstraints();
            pampin.setLayout(subgb3);
            this.modelwigin = new SpinnerNumberModel((double)this.newWiggles, 0.0, 1000.0, 1.0);
            JLabel wigin = new JLabel("  " + this.language.getString("Wiggles"), 4);
            JSpinner spwigin = new JSpinner(this.modelwigin);
            subc3.gridx = 0;
            subc3.gridy = 0;
            subgb3.setConstraints(wigin, subc3);
            pwigin.add((Component)wigin, subc3);
            subc3.gridx = 1;
            subc3.gridy = 0;
            spwigin.setPreferredSize(new Dimension(60, 20));
            subgb3.setConstraints(spwigin, subc3);
            pwigin.add((Component)spwigin, subc3);
            JPanel awSPanel = new JPanel();
            GridBagLayout gb2 = new GridBagLayout();
            GridBagConstraints sc2 = new GridBagConstraints();
            awSPanel.setLayout(gb2);
            sc2.gridx = 0;
            sc2.gridy = 0;
            gb2.setConstraints(pampin, sc2);
            awSPanel.add((Component)pampin, sc2);
            sc2.gridx = 0;
            sc2.gridy = 1;
            sc2.insets = new Insets(0, 0, 0, 0);
            gb2.setConstraints(pwigin, sc2);
            awSPanel.add((Component)pwigin, sc2);
            finalAwSPanel.setLayout(new BoxLayout(finalAwSPanel, 0));
            TitledBorder awSTitle = BorderFactory.createTitledBorder(this.language.getString("Amplitude/Wiggles"));
            finalAwSPanel.setBorder(awSTitle);
            finalAwSPanel.add(awSPanel);
        }
        if (this.theArc instanceof JaFArc || this.theArc instanceof JaSArc || this.theArc instanceof JaGArc) {
            this.arrowcb = new JCheckBox(this.language.getString("Arrow"));
            this.arrowcb.setSelected(this.theArc.getArrow());
            this.arrowcb.addItemListener(this);
            this.flipcb = new JCheckBox(this.language.getString("Flip"));
            this.flipcb.setSelected(this.theArc.getFlip());
            this.flipcb.addItemListener(this);
            this.arcArrowPanel = new JPanel();
            this.arcArrowPanel.setLayout(new GridLayout(0, 1));
            this.arcArrowTitle = BorderFactory.createTitledBorder(this.language.getString("Arrow"));
            this.arcArrowPanel.setBorder(this.arcArrowTitle);
            this.arcArrowPanel.add(this.arrowcb);
            this.arcArrowPanel.add(this.flipcb);
        }
        if (this.theArc instanceof JaFArc || this.theArc instanceof JaSArc || this.theArc instanceof JaGArc) {
            this.middlerb = new JRadioButton(this.language.getString("Middle"));
            this.middlerb.setSelected(!this.newEnd);
            this.middlerb.addItemListener(this);
            this.endrb = new JRadioButton(this.language.getString("End"));
            this.endrb.setSelected(this.newEnd);
            if (this.theArc instanceof JaSArc || this.theArc instanceof JaGArc) {
                this.endrb.setEnabled(false);
            }
            this.endrb.addItemListener(this);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.middlerb);
            bg.add(this.endrb);
            this.arcMiddlePanel = new JPanel();
            this.arcMiddlePanel.setLayout(new GridLayout(0, 1));
            this.arcMiddleTitle = BorderFactory.createTitledBorder(this.language.getString("Arrow_Position"));
            this.arcMiddlePanel.setBorder(this.arcMiddleTitle);
            this.arcMiddlePanel.add(this.middlerb);
            this.arcMiddlePanel.add(this.endrb);
        }
        this.dlcb = new JCheckBox(this.language.getString("Double_line"));
        this.dlcb.setSelected(this.newDLine);
        this.dlcb.addItemListener(this);
        SpinnerNumberModel modelsep = new SpinnerNumberModel(this.newDLSep, 0.5, 5.0, 0.5);
        this.stsep = new JLabel(this.language.getString("Separation") + ": ");
        this.spsep = new JSpinner(modelsep);
        this.stsep.setEnabled(this.newDLine);
        this.spsep.setEnabled(this.newDLine);
        JPanel dlP = new JPanel();
        GridBagLayout subdl = new GridBagLayout();
        GridBagConstraints subcdl = new GridBagConstraints();
        dlP.setLayout(subdl);
        subcdl.gridx = 0;
        subcdl.gridy = 0;
        subdl.setConstraints(this.dlcb, subcdl);
        dlP.add((Component)this.dlcb, subcdl);
        subcdl.gridx = 0;
        subcdl.gridy = 1;
        subcdl.insets = new Insets(5, 0, 5, 0);
        subdl.setConstraints(this.stsep, subcdl);
        dlP.add((Component)this.stsep, subcdl);
        subcdl.gridx = 1;
        subcdl.gridy = 1;
        subcdl.insets = new Insets(5, 0, 5, 5);
        this.spsep.setPreferredSize(new Dimension(50, 20));
        subdl.setConstraints(this.spsep, subcdl);
        dlP.add((Component)this.spsep, subcdl);
        JPanel dlPanel = new JPanel();
        dlPanel.setLayout(new BoxLayout(dlPanel, 0));
        TitledBorder dlTitle = BorderFactory.createTitledBorder(this.language.getString("Double_line"));
        dlPanel.setBorder(dlTitle);
        dlPanel.add(dlP);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 5);
        gridbag.setConstraints(finalDimSPanel, c);
        this.add((Component)finalDimSPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 5);
        gridbag.setConstraints(finalStrSPanel, c);
        this.add((Component)finalStrSPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        this.colorPanel.setPreferredSize(new Dimension(100, 70));
        gridbag.setConstraints(this.colorPanel, c);
        this.add((Component)this.colorPanel, c);
        if (this.theArc instanceof JaFArc || this.theArc instanceof JaSArc || this.theArc instanceof JaGArc) {
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 5, 0);
            this.arcArrowPanel.setPreferredSize(new Dimension(100, 70));
            gridbag.setConstraints(this.arcArrowPanel, c);
            this.add((Component)this.arcArrowPanel, c);
            c.gridx = 2;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 5, 0);
            this.arcMiddlePanel.setPreferredSize(new Dimension(150, 70));
            gridbag.setConstraints(this.arcMiddlePanel, c);
            this.add((Component)this.arcMiddlePanel, c);
            c.gridx = 2;
            c.gridy = 1;
            gridbag.setConstraints(dlPanel, c);
            this.add((Component)dlPanel, c);
        } else {
            c.gridx = 1;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 5, 5);
            gridbag.setConstraints(finalAwSPanel, c);
            this.add((Component)finalAwSPanel, c);
            c.gridx = 2;
            c.gridy = 0;
            gridbag.setConstraints(dlPanel, c);
            this.add((Component)dlPanel, c);
        }
        Object[] optionButtonNames = new String[]{this.language.getString("Accept"), this.language.getString("Cancel")};
        int n = JOptionPane.showOptionDialog(this, this, this.theParticle, 2, 1, this.theIcon, optionButtonNames, optionButtonNames[0]);
        if (n == 0) {
            this.theArc.setArrow(this.newArrow);
            this.theArc.setEnd(this.newEnd);
            this.theArc.setFlip(this.newFlip);
            if (this.newColor != null) {
                this.theArc.setColor(this.newColor);
            }
            int x1 = modelX1.getNumber().intValue();
            int y1 = modelY1.getNumber().intValue();
            int x2 = modelX2.getNumber().intValue();
            int y2 = modelY2.getNumber().intValue();
            int x3 = modelX3.getNumber().intValue();
            int y3 = modelY3.getNumber().intValue();
            this.theArc.setArcPts(x1, y1, x2, y2, x3, y3);
            double[] par = this.theArc.getArcParameters();
            this.newStroke = Math.abs(modelstin.getNumber().floatValue());
            this.newDash = Math.abs(modeldsin.getNumber().floatValue());
            if (this.theArc instanceof JaPArc || this.theArc instanceof JaGlArc) {
                this.newAmp = (int)this.modelampin.getNumber().floatValue();
                this.newWiggles = (int)this.modelwigin.getNumber().floatValue();
            }
            if (this.theArc instanceof JaPArc) {
                this.newFreq = (float)(par[2] * 2.0 * Math.abs(par[3] / 2.0) / (double)this.newWiggles);
            }
            if (this.theArc instanceof JaGlArc) {
                this.newFreq = (float)(par[2] * 2.0 * Math.abs(par[3] / 2.0) / (double)((float)this.newWiggles * 0.6f + 1.0f));
            }
            this.theArc.setDash(this.newDash);
            this.theArc.setStroke(this.newStroke);
            this.theArc.setDoubleLine(this.newDLine);
            this.newDLSep = modelsep.getNumber().floatValue();
            this.theArc.setDLSeparation(this.newDLSep);
            this.theArc.setAmp(this.newAmp);
            this.theArc.setFreq(this.newFreq);
            this.changed = true;
        }
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    @Override
    public final void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.arrowcb) {
            this.newArrow = !this.newArrow;
            this.flipcb.setEnabled(this.newArrow);
            this.middlerb.setEnabled(this.newArrow);
            if (this.theArc instanceof JaFArc) {
                this.endrb.setEnabled(this.newArrow);
            }
        } else if (source == this.flipcb) {
            this.newFlip = !this.newFlip;
        } else if (source == this.middlerb) {
            this.newEnd = false;
        } else if (source == this.endrb) {
            this.newEnd = true;
        } else if (source == this.dlcb) {
            this.newDLine = !this.newDLine;
            this.stsep.setEnabled(this.newDLine);
            this.spsep.setEnabled(this.newDLine);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorbt) {
            JaxoColorChooser colorChooser = new JaxoColorChooser();
            this.newColor = colorChooser.color(this.newColor, false);
            if (this.newColor != null) {
                this.colorPreviewIcon = new ImageIcon(this.getChooserImage(this.newColor));
                this.colorbt.setIcon(this.colorPreviewIcon);
            }
        }
    }

    private Image getChooserImage(Color iconColor) {
        int width = 40;
        int height = 15;
        int size = width * height;
        int[] pixels = new int[size];
        for (int i = 0; i < size; ++i) {
            pixels[i] = iconColor.getRGB();
        }
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image jaxColorBox = this.createImage(source);
        return jaxColorBox;
    }
}

