/*
 * Decompiled with CFR 0.152.
 */
package japlot.jaxodraw;

import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JaxoActionButtons
extends JPanel
implements ActionListener {
    private static final String[] ACTION_BUTTON_ICONS = new String[]{"japlot/jaxodraw/icons/undo.png", "japlot/jaxodraw/icons/clear.png", "japlot/jaxodraw/icons/refresh.png"};
    private JaxoMainPanel thePanel;
    private ResourceBundle language = ResourceBundle.getBundle(JaxoPrefs.getPref(4));
    private int anbts = 3;
    private JButton[] actionButtons = new JButton[this.anbts];
    private String[] actionTips = new String[]{this.language.getString("Undo_the_last_operation"), this.language.getString("Clear_the_screen"), this.language.getString("Refresh_the_Screen")};
    private Border raisedetched = BorderFactory.createEtchedBorder(0);
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();

    public JaxoActionButtons(JaxoMainPanel mainPanel) {
        this.thePanel = mainPanel;
        JPanel actionButtonPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        actionButtonPanel.setLayout(gridbag);
        for (int i = 0; i < this.anbts; ++i) {
            this.actionButtons[i] = new JButton();
            this.actionButtons[i].setIcon(new ImageIcon(JaxoActionButtons.class.getClassLoader().getResource(ACTION_BUTTON_ICONS[i])));
            this.actionButtons[i].setToolTipText(this.actionTips[i]);
            this.actionButtons[i].addActionListener(this);
            this.actionButtons[i].setMinimumSize(new Dimension(40, 40));
            this.actionButtons[i].setPreferredSize(new Dimension(40, 40));
            this.actionButtons[i].setBorder(this.raisedbevel);
            this.actionButtons[i].setFocusPainted(false);
        }
        for (int j = 0; j < 1; ++j) {
            for (int i = 0; i < 3; ++i) {
                c.gridx = i;
                c.gridy = j;
                gridbag.setConstraints(this.actionButtons[i + 3 * j], c);
                actionButtonPanel.add(this.actionButtons[i + 3 * j]);
            }
        }
        JPanel finalActionButtonPanel = new JPanel();
        finalActionButtonPanel.setLayout(new BorderLayout());
        finalActionButtonPanel.setBorder(this.raisedetched);
        finalActionButtonPanel.add((Component)actionButtonPanel, "Center");
        this.setLayout(new GridLayout(0, 1));
        this.add(finalActionButtonPanel);
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.anbts; ++i) {
            if (evt.getSource() != this.actionButtons[i]) continue;
            this.thePanel.actionEvent(this.getActionEvent(i));
        }
    }

    public final void reset() {
        for (int i = 0; i < this.anbts; ++i) {
            this.setButtonBorder(i, this.raisedbevel);
            this.setButtonBackground(i, null);
        }
    }

    public final int getanbts() {
        return this.anbts;
    }

    public final void setButtonBackground(int i, Color bgColor) {
        this.actionButtons[i].setBackground(bgColor);
    }

    public final void setButtonBorder(int i, Border border) {
        this.actionButtons[i].setBorder(border);
    }

    public final void setLanguage(String languageString) {
        this.language = ResourceBundle.getBundle(languageString);
        this.actionTips[0] = this.language.getString("Undo_the_last_operation");
        this.actionTips[1] = this.language.getString("Clear_the_screen");
        this.actionTips[2] = this.language.getString("Refresh_the_Screen");
        for (int i = 0; i < this.anbts; ++i) {
            this.actionButtons[i].setToolTipText(this.actionTips[i]);
        }
    }

    public final int getActionEvent(int i) {
        int actionEvent = this.anbts + 1;
        if (i == 0) {
            actionEvent = 42;
        }
        if (i == 1) {
            actionEvent = 43;
        }
        if (i == 2) {
            actionEvent = 45;
        }
        return actionEvent;
    }
}

