/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.relativity;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.physics.relativity.Tensor;

public class Rank4Tensor
extends Tensor {
    protected double[][][][] rank4 = new double[4][4][4][4];

    public boolean equals(Object a) {
        if (a instanceof Rank4Tensor) {
            Rank4Tensor v = (Rank4Tensor)a;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        if (!(Math.abs(this.rank4[i][j][k][0] - v.rank4[i][j][k][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank4[i][j][k][1] - v.rank4[i][j][k][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank4[i][j][k][2] - v.rank4[i][j][k][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank4[i][j][k][3] - v.rank4[i][j][k][3]) > GlobalSettings.ZERO_TOL)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public double getComponent(int i, int j, int k, int l) {
        if (i >= 0 && i < 4 && j >= 0 && j < 4 && k >= 0 && k < 4 && l >= 0 && l < 4) {
            return this.rank4[i][j][k][l];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int i, int j, int k, int l, double x) {
        if (i < 0 || i >= 4 || j < 0 || j >= 4 || k < 0 || k >= 4 || l < 0 || l >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank4[i][j][k][l] = x;
    }

    public Rank4Tensor add(Rank4Tensor t) {
        Rank4Tensor ans = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    ans.setComponent(i, j, k, 0, this.rank4[i][j][k][0] + t.rank4[i][j][k][0]);
                    ans.setComponent(i, j, k, 1, this.rank4[i][j][k][1] + t.rank4[i][j][k][1]);
                    ans.setComponent(i, j, k, 2, this.rank4[i][j][k][2] + t.rank4[i][j][k][2]);
                    ans.setComponent(i, j, k, 3, this.rank4[i][j][k][3] + t.rank4[i][j][k][3]);
                }
            }
        }
        return ans;
    }

    public Rank4Tensor subtract(Rank4Tensor t) {
        Rank4Tensor ans = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    ans.setComponent(i, j, k, 0, this.rank4[i][j][k][0] - t.rank4[i][j][k][0]);
                    ans.setComponent(i, j, k, 1, this.rank4[i][j][k][1] - t.rank4[i][j][k][1]);
                    ans.setComponent(i, j, k, 2, this.rank4[i][j][k][2] - t.rank4[i][j][k][2]);
                    ans.setComponent(i, j, k, 3, this.rank4[i][j][k][3] - t.rank4[i][j][k][3]);
                }
            }
        }
        return ans;
    }
}

