/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.relativity;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.physics.relativity.Rank1Tensor;
import jsci.physics.relativity.Rank3Tensor;
import jsci.physics.relativity.Rank4Tensor;
import jsci.physics.relativity.Tensor;

public class Rank2Tensor
extends Tensor {
    protected double[][] rank2 = new double[4][4];

    public boolean equals(Object a) {
        if (a instanceof Rank2Tensor) {
            Rank2Tensor v = (Rank2Tensor)a;
            for (int i = 0; i < 4; ++i) {
                if (!(Math.abs(this.rank2[i][0] - v.rank2[i][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[i][1] - v.rank2[i][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[i][2] - v.rank2[i][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank2[i][3] - v.rank2[i][3]) > GlobalSettings.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int i, int j) {
        if (i >= 0 && i < 4 && j >= 0 && j < 4) {
            return this.rank2[i][j];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int i, int j, double x) {
        if (i < 0 || i >= 4 || j < 0 || j >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank2[i][j] = x;
    }

    public Rank2Tensor add(Rank2Tensor t) {
        Rank2Tensor ans = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            ans.setComponent(i, 0, this.rank2[i][0] + t.rank2[i][0]);
            ans.setComponent(i, 1, this.rank2[i][1] + t.rank2[i][1]);
            ans.setComponent(i, 2, this.rank2[i][2] + t.rank2[i][2]);
            ans.setComponent(i, 3, this.rank2[i][3] + t.rank2[i][3]);
        }
        return ans;
    }

    public Rank2Tensor subtract(Rank2Tensor t) {
        Rank2Tensor ans = new Rank2Tensor();
        for (int i = 0; i < 4; ++i) {
            ans.setComponent(i, 0, this.rank2[i][0] - t.rank2[i][0]);
            ans.setComponent(i, 1, this.rank2[i][1] - t.rank2[i][1]);
            ans.setComponent(i, 2, this.rank2[i][2] - t.rank2[i][2]);
            ans.setComponent(i, 3, this.rank2[i][3] - t.rank2[i][3]);
        }
        return ans;
    }

    public Rank1Tensor multiply(Rank1Tensor t) {
        Rank1Tensor ans = new Rank1Tensor();
        ans.setComponent(0, this.rank2[0][0] * t.getComponent(0) + this.rank2[0][1] * t.getComponent(1) + this.rank2[0][2] * t.getComponent(2) + this.rank2[0][3] * t.getComponent(3));
        ans.setComponent(1, this.rank2[1][0] * t.getComponent(0) + this.rank2[1][1] * t.getComponent(1) + this.rank2[1][2] * t.getComponent(2) + this.rank2[1][3] * t.getComponent(3));
        ans.setComponent(2, this.rank2[2][0] * t.getComponent(0) + this.rank2[2][1] * t.getComponent(1) + this.rank2[2][2] * t.getComponent(2) + this.rank2[2][3] * t.getComponent(3));
        ans.setComponent(3, this.rank2[3][0] * t.getComponent(0) + this.rank2[3][1] * t.getComponent(1) + this.rank2[3][2] * t.getComponent(2) + this.rank2[3][3] * t.getComponent(3));
        return ans;
    }

    public Rank3Tensor tensorProduct(Rank1Tensor t) {
        Rank3Tensor ans = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ans.setComponent(i, j, 0, this.rank2[i][j] * t.getComponent(0));
                ans.setComponent(i, j, 1, this.rank2[i][j] * t.getComponent(1));
                ans.setComponent(i, j, 2, this.rank2[i][j] * t.getComponent(2));
                ans.setComponent(i, j, 3, this.rank2[i][j] * t.getComponent(3));
            }
        }
        return ans;
    }

    public Rank4Tensor tensorProduct(Rank2Tensor t) {
        Rank4Tensor ans = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    ans.setComponent(i, j, k, 0, this.rank2[i][j] * t.rank2[k][0]);
                    ans.setComponent(i, j, k, 1, this.rank2[i][j] * t.rank2[k][1]);
                    ans.setComponent(i, j, k, 2, this.rank2[i][j] * t.rank2[k][2]);
                    ans.setComponent(i, j, k, 3, this.rank2[i][j] * t.rank2[k][3]);
                }
            }
        }
        return ans;
    }
}

