/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiTauNeutrino;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.Tau;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class TauNeutrino
extends Lepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 1;
    }

    @Override
    public QuantumParticle anti() {
        return new AntiTauNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof AntiTauNeutrino;
    }

    public String toString() {
        return new String("Tau neutrino");
    }

    public Tau emit(WPlus w) {
        Tau e = new Tau();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public Tau absorb(WMinus w) {
        Tau e = new Tau();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public TauNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public TauNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

