/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiTau;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.Photon;
import jsci.physics.particles.TauNeutrino;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class Tau
extends Lepton {
    @Override
    public double restMass() {
        return 1777.03;
    }

    @Override
    public int charge() {
        return -1;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 1;
    }

    @Override
    public QuantumParticle anti() {
        return new AntiTau();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof AntiTau;
    }

    public String toString() {
        return new String("Tau");
    }

    public Tau emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public Tau absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public TauNeutrino emit(WMinus w) {
        TauNeutrino n = new TauNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public TauNeutrino absorb(WPlus w) {
        TauNeutrino n = new TauNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public Tau emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public Tau absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

